/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.security;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.GridSecurity;
import org.gridgain.grid.internal.processors.security.GridEntSecurityProcessor;

public class GridSecurityImpl
implements GridSecurity,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridEntSecurityProcessor secProc;
    private GridKernalContext ctx;

    public GridSecurityImpl() {
    }

    public GridSecurityImpl(GridEntSecurityProcessor secProc, GridKernalContext ctx) {
        this.secProc = secProc;
        this.ctx = ctx;
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() throws IgniteException {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            Collection<SecuritySubject> collection = this.secProc.authenticatedSubjects();
            this.ctx.gateway().readUnlock();
            return collection;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) throws IgniteException {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            SecuritySubject securitySubject = this.secProc.authenticatedSubject(subjId);
            this.ctx.gateway().readUnlock();
            return securitySubject;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridKernalContext)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        GridGain plugin = (GridGain)this.ctx.grid().plugin("GridGain");
        return plugin.security();
    }
}

