/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.security;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.gridgain.grid.internal.processors.security.AllowAllPermissionSet;
import org.gridgain.grid.internal.processors.security.SecuritySubjectAdapter;
import org.gridgain.grid.security.Authenticator;

public class GridAuthenticatorHandler {
    private Authenticator authenticator;

    public GridAuthenticatorHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public SecuritySubject authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        if (this.authenticator == null) {
            SecuritySubjectAdapter s2 = new SecuritySubjectAdapter(authCtx.subjectType(), authCtx.subjectId());
            s2.permissions(new AllowAllPermissionSet());
            s2.address(authCtx.address());
            if (authCtx.credentials() != null) {
                s2.login(authCtx.credentials().getLogin());
            }
            s2.certificates(authCtx.certificates());
            return s2;
        }
        if (this.authenticator.supported(authCtx.subjectType())) {
            try {
                return this.authenticator.authenticate(authCtx);
            }
            catch (IgniteException e) {
                throw new IgniteCheckedException(e);
            }
        }
        throw new IgniteCheckedException("Failed to find authenticator.");
    }
}

