/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.nodevalidation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.ru.IgniteRollingUpgradeStatus;
import org.apache.ignite.internal.processors.ru.RollingUpgradeModeChangeResult;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.GridGainFeatures;
import org.gridgain.grid.internal.processors.nodevalidation.DistributedRollingUpgradeStatus;
import org.gridgain.grid.internal.processors.nodevalidation.NodeValidationException;
import org.gridgain.grid.internal.processors.nodevalidation.RollingUpgradeMXBeanImpl;
import org.gridgain.grid.internal.util.GridGainProperties;
import org.gridgain.grid.internal.visor.nodevalidation.VisorRollingUpgradeChangeModeTask;
import org.gridgain.grid.internal.visor.nodevalidation.VisorRollingUpgradeChangeModeTaskArg;
import org.gridgain.grid.ru.RollingUpgradeMXBean;
import org.jetbrains.annotations.Nullable;

public class GridEntDiscoveryNodeValidationProcessor
extends GridProcessorAdapter
implements DiscoveryNodeValidationProcessor {
    public static final String DISTRIBUTED_ROLLING_UPGRADE_STATUS = "distributedRollingUpgradeStatus";
    public static final String ROLLING_UPGRADE_REJECT_MSG = "Local node's build version differs from remote node's [locBuildVer=%s, rmtBuildVer=%s]. The node has been rejected due to disabled Rolling Upgrade. Please consider to enable it via control.sh utility with the following command: `--rolling-upgrade start` or using GridGain.rollingUpgrade().start() method.";
    private static final String ROLLING_UPGRADE_MBEAN_NAME = "RollingUpgrade";
    private static String compVers = GridGainProperties.get("gridgain.compatible.vers");
    private static String incompVers = GridGainProperties.get("gridgain.incompatible.vers");
    private static String vers = GridGainProperties.get("gridgain.version");
    private static final String BUILD_TSTAMP_STR = IgniteVersionUtils.formatBuildTimeStamp(Long.valueOf(GridGainProperties.get("gridgain.build")) * 1000L);
    private final DistributedRollingUpgradeStatus distributedRollingUpgradeStatus = DistributedRollingUpgradeStatus.detachedProperty("distributedRollingUpgradeStatus");
    @GridToStringExclude
    private final Collection<String> compatibleVers;
    @GridToStringExclude
    private final Collection<String> incompatibleVers;
    @GridToStringExclude
    private final boolean isRolUpd;
    @GridToStringExclude
    private final Object mux = new Object();
    @GridToStringExclude
    private IgniteRollingUpgradeStatus rollingUpgradeStatus;
    @GridToStringExclude
    private final DiscoveryEventListener forceModeActivatorLsnr = (evt, discoCache) -> {
        if (this.distributedRollingUpgradeAvailable()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("All nodes already support distributed rolling upgrade. It activated in force mode.");
            }
            this.ctx.rollingUpgrade().enableForcedMode();
            this.ctx.event().removeDiscoveryEventListener(this.forceModeActivatorLsnr, new int[0]);
        }
    };
    private volatile ObjectName rollingUpgradeMBeanName;

    public GridEntDiscoveryNodeValidationProcessor(GridKernalContext ctx) {
        super(ctx);
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.distributedRollingUpgradeStatus.addListener((name, oldVal, newVal) -> {
                Object object = this.mux;
                synchronized (object) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rolling upgrade state was updated [oldVal= " + oldVal + ", newVal=" + newVal + ']');
                    }
                    this.rollingUpgradeStatus = newVal;
                }
            });
            dispatcher.registerProperty(this.distributedRollingUpgradeStatus);
        });
        String[] compatibleVers = compVers.split(",");
        for (int i = 0; i < compatibleVers.length; ++i) {
            compatibleVers[i] = compatibleVers[i].trim();
        }
        String[] incompatibleVers = incompVers.split(",");
        for (int i = 0; i < incompatibleVers.length; ++i) {
            incompatibleVers[i] = incompatibleVers[i].trim();
        }
        this.compatibleVers = Collections.unmodifiableList(Arrays.asList(compatibleVers));
        this.incompatibleVers = Collections.unmodifiableList(Arrays.asList(incompatibleVers));
        GridGain gg = (GridGain)ctx.pluginProvider("GridGain").plugin();
        this.isRolUpd = gg.configuration().isRollingUpdatesEnabled();
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute("plugins.gg.build.ver", vers);
        this.ctx.addNodeAttribute("plugins.gg.compatible.vers", this.compatibleVers);
        this.ctx.addNodeAttribute("plugins.gg.incompatible.vers", this.incompatibleVers);
        this.ctx.addNodeAttribute("plugins.gg.build.date", BUILD_TSTAMP_STR);
        this.ctx.addNodeAttribute("plugins.ggrolling.updates", this.isRolUpd);
        this.ctx.addNodeAttribute("plugins.gg.supported.features", GridGainFeatures.allFeatures());
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        Collection<ClusterNode> remotes = this.ctx.discovery().remoteNodes();
        for (ClusterNode node : remotes) {
            this.checkRemoteNode(node);
        }
        if (!this.distributedRollingUpgradeAvailable()) {
            this.ctx.event().addDiscoveryEventListener(this.forceModeActivatorLsnr, 12, 11);
        } else {
            this.registerRollingUpgradeMXBean();
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.ctx.event().removeDiscoveryEventListener(this.forceModeActivatorLsnr, new int[0]);
        this.unregisterRollingUpgradeMXBean();
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode joiningNode) {
        try {
            this.securitySupportCheck(joiningNode);
            this.checkRemoteNode(joiningNode);
            return this.distributedRollingUpgradeAvailable() ? this.rollingUpgradeProcessValidation(joiningNode) : null;
        }
        catch (NodeValidationException e) {
            return new IgniteNodeValidationResult(joiningNode.id(), e.getMessage(), e.getSendMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollingUpgradeModeChangeResult setMode(boolean enable) {
        try {
            IgniteInternalFuture<RollingUpgradeStatus> changeModeFut;
            ClusterNode crd = this.ctx.discovery().discoCache().oldestAliveServerNode();
            if (!crd.isLocal() && IgniteFeatures.nodeSupports(this.ctx, crd, IgniteFeatures.DISTRIBUTED_ROLLING_UPGRADE_MODE_V2)) {
                return (RollingUpgradeModeChangeResult)this.ctx.task().execute(VisorRollingUpgradeChangeModeTask.class, new VisorTaskArgument<VisorRollingUpgradeChangeModeTaskArg>(crd.id(), VisorRollingUpgradeChangeModeTaskArg.create(enable), false)).get();
            }
            Object object = this.mux;
            synchronized (object) {
                if (!this.distributedRollingUpgradeAvailable()) {
                    return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, new UnsupportedOperationException("Rolling Upgrade is not supported."), this.getStatus());
                }
                if (enable && !this.isRolUpd) {
                    return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, new IgniteException("Rolling Upgrade mode cannot be enabled. Consider changing 'GridGainConfiguration.rollingUpdatesEnabled' configuration property."), this.getStatus());
                }
                changeModeFut = enable ? this.enableRollingUpgrade() : this.disableRollingUpgrade();
            }
            return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.SUCCESS, changeModeFut.get());
        }
        catch (IgniteCheckedException e) {
            return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, new IgniteException("Rolling Upgrade mode cannot be " + (enable ? "enabled" : "disabled") + ". " + e.getMessage(), e), this.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollingUpgradeModeChangeResult enableForcedMode() {
        try {
            ClusterNode crd = this.ctx.discovery().discoCache().oldestAliveServerNode();
            if (!crd.isLocal() && IgniteFeatures.nodeSupports(this.ctx, crd, IgniteFeatures.DISTRIBUTED_ROLLING_UPGRADE_MODE_V2)) {
                return (RollingUpgradeModeChangeResult)this.ctx.task().execute(VisorRollingUpgradeChangeModeTask.class, new VisorTaskArgument<VisorRollingUpgradeChangeModeTaskArg>(crd.id(), VisorRollingUpgradeChangeModeTaskArg.createForce(), false)).get();
            }
            GridFutureAdapter changeModeFut = new GridFutureAdapter();
            Object object = this.mux;
            synchronized (object) {
                if (!this.distributedRollingUpgradeAvailable()) {
                    return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, new UnsupportedOperationException("Forced mode of Rolling Upgrade is not supported."), this.getStatus());
                }
                if (!this.isRolUpd) {
                    return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, new IgniteException("Rolling Upgrade mode cannot be enabled. Consider changing 'GridGainConfiguration.rollingUpdatesEnabled' configuration property."), this.getStatus());
                }
                IgniteRollingUpgradeStatus newStatus = new IgniteRollingUpgradeStatus(true, true, this.ctx.discovery().localNode().version(), null, IgniteFeatures.allFeatures(this.ctx));
                this.distributedRollingUpgradeStatus.propagateAsync(newStatus).listen(f -> {
                    if (f.error() != null) {
                        changeModeFut.onDone(f.error());
                    } else {
                        changeModeFut.onDone(newStatus);
                    }
                });
                this.rollingUpgradeStatus = newStatus;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Forced rolling upgrade mode enabled.");
                }
            }
            return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.SUCCESS, (RollingUpgradeStatus)changeModeFut.get());
        }
        catch (IgniteCheckedException e) {
            return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, new IgniteException("Forced mode of rolling upgrade cannot be enabled. " + e.getMessage(), e), this.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteRollingUpgradeStatus getStatus() {
        Object object = this.mux;
        synchronized (object) {
            if (this.rollingUpgradeStatus == null) {
                this.rollingUpgradeStatus = new IgniteRollingUpgradeStatus(false, false, this.ctx.discovery().localNode().version(), null, IgniteFeatures.allFeatures(this.ctx));
            }
            return this.rollingUpgradeStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteNodeValidationResult rollingUpgradeProcessValidation(ClusterNode joiningNode) throws NodeValidationException {
        Object object = this.mux;
        synchronized (object) {
            boolean acceptableVer;
            IgniteRollingUpgradeStatus status = this.getStatus();
            IgniteProductVersion crdNodeVer = this.ctx.discovery().localNode().version();
            IgniteProductVersion joiningNodeVer = joiningNode.version();
            boolean sameVer = !status.enabled() && crdNodeVer.compareToIgnoreTimestamp(joiningNodeVer) == 0;
            boolean bl = acceptableVer = status.enabled() && (joiningNodeVer.compareToIgnoreTimestamp(status.initialVersion()) == 0 || status.targetVersion() != null && joiningNodeVer.compareToIgnoreTimestamp(status.targetVersion()) == 0);
            if (status.forcedModeEnabled() || sameVer || acceptableVer) {
                return null;
            }
            if (!status.enabled()) {
                throw new NodeValidationException(String.format(ROLLING_UPGRADE_REJECT_MSG, crdNodeVer, joiningNodeVer), String.format(ROLLING_UPGRADE_REJECT_MSG, joiningNodeVer, crdNodeVer));
            }
            if (joiningNodeVer.compareToIgnoreTimestamp(status.initialVersion()) != 0 && status.targetVersion() != null && joiningNodeVer.compareToIgnoreTimestamp(status.targetVersion()) != 0) {
                return new IgniteNodeValidationResult(joiningNode.id(), "Node was rejected. The cluster has already two versions for rolling upgrade [initVer=" + status.initialVersion() + ", targetVer=" + status.targetVersion() + ", nodeVer=" + joiningNodeVer + ']', "The cluster has already two versions for rolling upgrade [initVer=" + status.initialVersion() + ", targetVer=" + status.targetVersion() + ", nodeVer=" + joiningNodeVer + ']');
            }
            if (status.targetVersion() == null && joiningNodeVer.compareToIgnoreTimestamp(status.initialVersion()) > 0) {
                IgniteRollingUpgradeStatus newState;
                this.rollingUpgradeStatus = newState = new IgniteRollingUpgradeStatus(status.enabled(), status.forcedModeEnabled(), status.initialVersion(), joiningNodeVer, status.supportedFeatures());
                try {
                    this.distributedRollingUpgradeStatus.propagateAsync(newState);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Target version was set. [initVer=" + newState.initialVersion() + ", targetVer=" + newState.targetVersion() + ']');
                    }
                }
                catch (IgniteCheckedException e) {
                    String msg = "Distributed metastore can't propagate value.";
                    this.log.error(msg, e);
                    return new IgniteNodeValidationResult(joiningNode.id(), msg, msg);
                }
                return null;
            }
            return new IgniteNodeValidationResult(joiningNode.id(), "Node was rejected. The cluster mustn't contain node older than initial [initVer=" + status.initialVersion() + ", nodeVer=" + joiningNodeVer + ']', "The cluster mustn't contain node older than initial [initVer=" + status.initialVersion() + ", nodeVer=" + joiningNodeVer + ']');
        }
    }

    private void checkRemoteNode(ClusterNode remote) throws NodeValidationException {
        ClusterNode loc = this.ctx.discovery().localNode();
        try {
            this.versionsCompatibilityCheck(loc, remote);
            this.rollingUpdatesCompatibilityCheck(loc, remote, null);
        }
        catch (NodeValidationException e) {
            this.warnAndDebug(e.getMessage());
            throw e;
        }
    }

    private void versionsCompatibilityCheck(ClusterNode loc, ClusterNode remote) throws NodeValidationException {
        String rmtIgniteVer;
        String locBuildVer = (String)loc.attribute("plugins.gg.build.ver");
        String rmtBuildVer = (String)remote.attribute("plugins.gg.build.ver");
        if (rmtBuildVer == null && (rmtIgniteVer = (String)remote.attribute("org.apache.ignite.build.ver")) != null) {
            String ptrn = "GridGain node cannot be in one cluster with Ignite node [locNodeAddrs=%s, rmtNodeAddrs=%s]";
            String locNodeAddrs = U.addressesAsString(loc);
            String rmtNodeAddrs = U.addressesAsString(remote);
            throw new NodeValidationException(String.format(ptrn, locNodeAddrs, rmtNodeAddrs), String.format(ptrn, rmtNodeAddrs, locNodeAddrs));
        }
        if (!F.eq(rmtBuildVer, locBuildVer)) {
            boolean incompatible;
            Collection locCompatibleVers = (Collection)loc.attribute("plugins.gg.compatible.vers");
            Collection rmtCompatibleVers = (Collection)remote.attribute("plugins.gg.compatible.vers");
            Collection locIncompatibleVers = (Collection)loc.attribute("plugins.gg.incompatible.vers");
            Collection rmtIncompatibleVers = (Collection)remote.attribute("plugins.gg.incompatible.vers");
            boolean compatible = GridEntDiscoveryNodeValidationProcessor.matchesAny(locBuildVer, rmtCompatibleVers) || GridEntDiscoveryNodeValidationProcessor.matchesAny(rmtBuildVer, locCompatibleVers);
            boolean bl = incompatible = GridEntDiscoveryNodeValidationProcessor.matchesAny(locBuildVer, rmtIncompatibleVers) || GridEntDiscoveryNodeValidationProcessor.matchesAny(rmtBuildVer, locIncompatibleVers);
            if (compatible && !incompatible) {
                String warnMsg = "Local node's build version differs from remote node's, but they are compatible (will try to continue join process). Rolling updates should be set to TRUE on both nodes in this case [locBuildVer=" + locBuildVer + ", rmtBuildVer=" + rmtBuildVer + ", locNodeAddrs=" + U.addressesAsString(loc) + ", rmtNodeAddrs=" + U.addressesAsString(remote) + ", locNodeId=" + loc.id() + ", rmtNodeId=" + remote.id() + ']';
                this.warnAndDebug(warnMsg);
                this.rollingUpdatesCompatibilityCheck(loc, remote, true);
            } else {
                String ptrn = "Local node's and remote node's build versions are not compatible [locBuildVer=%s, rmtBuildVer=%s, locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s]";
                Object[] locParams = new Object[]{locBuildVer, U.addressesAsString(loc), loc.id()};
                Object[] rmtParams = new Object[]{rmtBuildVer, U.addressesAsString(remote), remote.id()};
                throw new NodeValidationException(String.format(ptrn, this.interleave(locParams, rmtParams)), String.format(ptrn, this.interleave(rmtParams, locParams)));
            }
        }
    }

    private void rollingUpdatesCompatibilityCheck(ClusterNode loc, ClusterNode remote, @Nullable Boolean expVal) throws NodeValidationException {
        Boolean isRmtRollUpd = (Boolean)remote.attribute("plugins.ggrolling.updates");
        if (isRmtRollUpd == null || isRmtRollUpd != this.isRolUpd) {
            String ptrn = "Rolling updates are not properly configured [locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s, locNodeIgniteVersion=%s, rmtNodeIgniteVersion=%s, locRollingUpdatesEnabled=%b, rmtRollingUpdatesEnabled=%b]";
            Object[] locParams = new Object[]{U.addressesAsString(loc), loc.id(), loc.version(), this.isRolUpd};
            Object[] rmtParams = new Object[]{U.addressesAsString(remote), remote.id(), remote.version(), isRmtRollUpd};
            throw new NodeValidationException(String.format(ptrn, this.interleave(locParams, rmtParams)), String.format(ptrn, this.interleave(rmtParams, locParams)));
        }
        if (expVal != null && this.isRolUpd != expVal) {
            String ptrn = "Rolling updates property should be set to " + expVal + "[locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s, locNodeIgniteVersion=%s, rmtNodeIgniteVersion=%s, locRollingUpdatesEnabled=%b, rmtRollingUpdatesEnabled=%b, rollingUpdatesExpectedValue=" + expVal + ']';
            Object[] locParams = new Object[]{U.addressesAsString(loc), loc.id(), loc.version(), this.isRolUpd};
            Object[] rmtParams = new Object[]{U.addressesAsString(remote), remote.id(), remote.version(), isRmtRollUpd};
            throw new NodeValidationException(String.format(ptrn, this.interleave(locParams, rmtParams)), String.format(ptrn, this.interleave(rmtParams, locParams)));
        }
    }

    private Object[] interleave(Object[] a1, Object[] a2) {
        assert (a1.length == a2.length);
        Object[] res = new Object[a1.length + a2.length];
        for (int i = 0; i < a1.length; ++i) {
            res[i * 2] = a1[i];
            res[i * 2 + 1] = a2[i];
        }
        return res;
    }

    private void warnAndDebug(String msg) {
        LT.warn(this.log, msg);
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg);
        }
    }

    private void securitySupportCheck(ClusterNode joiningNode) throws NodeValidationException {
        if (IgniteFeatures.allNodesSupports(this.ctx, this.ctx.discovery().allNodes(), IgniteFeatures.IGNITE_SECURITY_PROCESSOR) && !IgniteFeatures.nodeSupports(this.ctx, joiningNode, IgniteFeatures.IGNITE_SECURITY_PROCESSOR)) {
            String msg = "The cluster with security messages can't connect node without support it.";
            throw new NodeValidationException(msg, msg);
        }
    }

    private IgniteInternalFuture<RollingUpgradeStatus> enableRollingUpgrade() throws IgniteCheckedException {
        IgniteRollingUpgradeStatus status = this.getStatus();
        if (!status.enabled()) {
            IgniteProductVersion initVer = this.ctx.discovery().localNode().version();
            IgniteRollingUpgradeStatus newState = new IgniteRollingUpgradeStatus(true, false, initVer, null, IgniteFeatures.allFeatures(this.ctx));
            GridFutureAdapter<RollingUpgradeStatus> ret = new GridFutureAdapter<RollingUpgradeStatus>();
            this.distributedRollingUpgradeStatus.propagateAsync(newState).listen(f -> {
                if (f.error() != null) {
                    ret.onDone(f.error());
                } else {
                    ret.onDone(newState);
                }
            });
            this.rollingUpgradeStatus = newState;
            if (this.log.isInfoEnabled()) {
                this.log.info("Rolling upgrade successfully enabled [status=" + newState + ']');
            }
            return ret;
        }
        return new GridFinishedFuture<RollingUpgradeStatus>(status);
    }

    private IgniteInternalFuture<RollingUpgradeStatus> disableRollingUpgrade() throws IgniteCheckedException {
        IgniteRollingUpgradeStatus status = this.getStatus();
        if (status.enabled()) {
            Collection<ClusterNode> nodes = this.ctx.discovery().allNodes();
            this.validateNodeVersions(nodes);
            IgniteRollingUpgradeStatus newState = new IgniteRollingUpgradeStatus(false, false, this.ctx.discovery().localNode().version(), null, IgniteFeatures.allFeatures(this.ctx));
            GridFutureAdapter<RollingUpgradeStatus> ret = new GridFutureAdapter<RollingUpgradeStatus>();
            this.distributedRollingUpgradeStatus.propagateAsync(newState).listen(f -> {
                if (f.error() != null) {
                    ret.onDone(f.error());
                } else {
                    ret.onDone(newState);
                }
            });
            this.rollingUpgradeStatus = newState;
            if (this.log.isInfoEnabled()) {
                this.log.info("Rolling upgrade successfully disabled.");
            }
            return ret;
        }
        return new GridFinishedFuture<RollingUpgradeStatus>(status);
    }

    private void validateNodeVersions(Collection<ClusterNode> nodes) throws IgniteCheckedException {
        Map<IgniteProductVersion, String> nodeVersions = nodes.stream().collect(Collectors.groupingBy(ClusterNode::version, Collectors.mapping(n -> n.consistentId().toString(), Collectors.joining(", ", "Nodes: [", "]"))));
        if (nodeVersions.size() > 1) {
            throw new IgniteCheckedException("Rolling upgrade cannot be disabled because there is more than one node with different product version. " + nodeVersions);
        }
    }

    protected static boolean matchesAny(String ver, Collection<String> templates) {
        if (F.isEmpty(templates)) {
            return false;
        }
        for (String template : templates) {
            if (!GridEntDiscoveryNodeValidationProcessor.matches(ver, template)) continue;
            return true;
        }
        return false;
    }

    protected static boolean matches(String ver, String template) {
        String[] templateTokens;
        int maxIdx;
        String[] verTokens = ver.split("\\.");
        if (verTokens.length < (maxIdx = Math.min((templateTokens = template.split("\\.")).length, 3))) {
            return false;
        }
        for (int i = 0; i < maxIdx; ++i) {
            String verTok = verTokens[i];
            String templateTok = templateTokens[i];
            if ("*".equals(templateTok) || F.eq(verTok, templateTok)) continue;
            return false;
        }
        return true;
    }

    private boolean distributedRollingUpgradeAvailable() {
        return IgniteFeatures.allNodesSupports(this.ctx, this.ctx.discovery().aliveServerNodes(), IgniteFeatures.DISTRIBUTED_ROLLING_UPGRADE_MODE);
    }

    private void registerRollingUpgradeMXBean() {
        if (U.IGNITE_MBEANS_DISABLED || this.rollingUpgradeMBeanName != null) {
            return;
        }
        RollingUpgradeMXBeanImpl ruMXBean = new RollingUpgradeMXBeanImpl(this.ctx);
        try {
            IgniteConfiguration cfg = this.ctx.config();
            this.rollingUpgradeMBeanName = U.registerMBean(cfg.getMBeanServer(), cfg.getIgniteInstanceName(), ROLLING_UPGRADE_MBEAN_NAME, ruMXBean.getClass().getSimpleName(), ruMXBean, RollingUpgradeMXBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered RollingUpgrade MBean: " + this.rollingUpgradeMBeanName);
            }
        }
        catch (JMException e) {
            U.error(this.log, "Failed to register RollingUpgrade MBean", e);
        }
    }

    private void unregisterRollingUpgradeMXBean() {
        ObjectName mBeanName = this.rollingUpgradeMBeanName;
        if (mBeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.ctx.config().getMBeanServer().unregisterMBean(mBeanName);
            this.rollingUpgradeMBeanName = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered RollingUpgrade MBean: " + mBeanName);
            }
        }
        catch (JMException e) {
            U.error(this.log, "Failed to unregister RollingUpgrade MBean: " + mBeanName, e);
        }
    }
}

