/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCorruptedException;
import org.gridgain.grid.dr.store.DrSenderStoreOverflowException;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.store.DrMetadataAwareStore;
import org.gridgain.grid.internal.processors.dr.store.DrStoreManager;

public class DrReplicaStoreManager
extends DrStoreManager {
    private final DrMetadataAwareStore[] storesPerReplica = new DrMetadataAwareStore[32];

    public DrReplicaStoreManager(GridKernalContext ctx, DrProcessor proc, long fstBufferSize, DrSenderConnectionConfiguration[] connCfgs) {
        super(ctx, proc, fstBufferSize);
        for (DrSenderConnectionConfiguration cfg : connCfgs) {
            DrSenderStore store = cfg.getStore();
            byte dataCenterId = cfg.getDataCenterId();
            this.initStoreDefaults(store, dataCenterId);
            this.storesPerReplica[dataCenterId] = new DrMetadataAwareStore(ctx, store);
        }
    }

    @Override
    public boolean isGlobalStore() {
        return false;
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        for (byte dcId = 0; dcId < this.storesPerReplica.length; dcId = (byte)((byte)(dcId + 1))) {
            DrMetadataAwareStore store = this.storesPerReplica[dcId];
            if (store == null) continue;
            store.start();
            this.proc.metrics().registerSenderDcStoreMetrics(dcId, () -> store.getStore().sizeBytes());
        }
        this.proc.metrics().registerSenderGlobalStateTransferBufferMetrics(this.fstBuffer::sizeBytes);
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        for (DrMetadataAwareStore store : this.storesPerReplica) {
            if (store == null) continue;
            store.onKernalStart();
        }
    }

    @Override
    public void stop() {
        super.stop();
        for (DrMetadataAwareStore store : this.storesPerReplica) {
            if (store == null) continue;
            store.stop();
        }
    }

    @Override
    public DrMetadataAwareStore getStore(byte dcID) {
        return Objects.requireNonNull(this.storesPerReplica[dcID], "Replica store is not configured for remote DC: " + dcID);
    }

    @Override
    public void clearGlobalStore() {
        throw new IllegalStateException("Global store is not configured.");
    }

    @Override
    public void storeRegularBatch(byte[] dataCenterIds, byte[] data, int cnt) throws IgniteCheckedException {
        ArrayList<Byte> overflownDcs = new ArrayList<Byte>();
        ArrayList<Byte> corruptedDcs = new ArrayList<Byte>();
        ArrayList<IgniteCheckedException> errs = new ArrayList<IgniteCheckedException>();
        for (byte dc : dataCenterIds) {
            try {
                this.getStore(dc).store(new byte[]{dc}, data, cnt);
                if (this.storeListeners[dc] == null) continue;
                this.storeListeners[dc].onBatchAdded();
            }
            catch (DrSenderStoreOverflowException ex) {
                overflownDcs.add(dc);
                errs.add(ex);
            }
            catch (IgniteCheckedException ex) {
                corruptedDcs.add(dc);
                errs.add(ex);
            }
        }
        IgniteCheckedException ex = null;
        if (!corruptedDcs.isEmpty()) {
            ex = new DrSenderStoreCorruptedException("Failed to save a batch: corruptedDC=" + Arrays.toString(corruptedDcs.toArray()) + (overflownDcs.isEmpty() ? "" : "overflownDC=" + Arrays.toString(overflownDcs.toArray())) + ", targetDC=" + Arrays.toString(dataCenterIds));
        } else if (!overflownDcs.isEmpty()) {
            ex = new DrSenderStoreOverflowException("Failed to save a batch: overflownDC=" + Arrays.toString(overflownDcs.toArray()) + ", targetDC=" + Arrays.toString(dataCenterIds));
        }
        if (ex != null) {
            errs.forEach(ex::addSuppressed);
            throw ex;
        }
    }
}

