/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.grid.internal.processors.dr.DrSenderMetadataHolder;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalBatchRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalBatchResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalHandshakeRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalHandshakeResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMetadataRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMetadataResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalPingRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalPingResponse;
import org.gridgain.grid.internal.processors.dr.nio.DrMessageMarshaller;

public class DrNioMessageMarshaller
implements DrMessageMarshaller<ByteBuffer> {
    private static final byte[] PING_REQ_BYTES = new byte[]{0, 0, 0, 1, 2};
    private static final byte[] PING_RESP_BYTES = new byte[]{0, 0, 0, 1, 3};
    private final boolean usingBinaryMarshaller;

    public DrNioMessageMarshaller(boolean usingBinaryMarshaller) {
        this.usingBinaryMarshaller = usingBinaryMarshaller;
    }

    @Override
    public Object unmarshal(ByteBuffer data) throws IgniteCheckedException {
        if (data.get(0) == 2) {
            return DrUtils.PING_REQ;
        }
        if (data.get(0) == 3) {
            return DrUtils.PING_RESP;
        }
        return DrUtils.unmarshal(data.array(), data.limit(), this.usingBinaryMarshaller);
    }

    @Override
    public byte[] toBytes(Object msg) throws IgniteCheckedException {
        ByteBuffer buf = this.marshal(msg);
        if (buf.limit() == buf.capacity()) {
            return buf.array();
        }
        byte[] arr = new byte[buf.limit()];
        buf.get(arr);
        return arr;
    }

    @Override
    public ByteBuffer marshal(Object msg) throws IgniteCheckedException {
        if (msg instanceof byte[]) {
            return ByteBuffer.wrap((byte[])msg);
        }
        if (msg instanceof DrExternalPingRequest) {
            return ByteBuffer.wrap(PING_REQ_BYTES);
        }
        if (msg instanceof DrExternalPingResponse) {
            return ByteBuffer.wrap(PING_RESP_BYTES);
        }
        if (msg instanceof DrExternalHandshakeRequest) {
            return DrNioMessageMarshaller.marshal((DrExternalHandshakeRequest)msg);
        }
        if (msg instanceof DrExternalHandshakeResponse) {
            return DrNioMessageMarshaller.marshal((DrExternalHandshakeResponse)msg);
        }
        if (msg instanceof DrExternalMetadataRequest) {
            return DrNioMessageMarshaller.marshal((DrExternalMetadataRequest)msg, this.usingBinaryMarshaller);
        }
        if (msg instanceof DrExternalMetadataResponse) {
            return DrNioMessageMarshaller.marshal((DrExternalMetadataResponse)msg);
        }
        if (msg instanceof DrExternalBatchRequest) {
            return DrNioMessageMarshaller.marshal((DrExternalBatchRequest)msg);
        }
        if (msg instanceof DrExternalBatchResponse) {
            return DrNioMessageMarshaller.marshal((DrExternalBatchResponse)msg);
        }
        throw new IllegalArgumentException("Message type is not supported.");
    }

    public static ByteBuffer marshal(DrExternalHandshakeResponse resp) throws IgniteCheckedException {
        int size = 6;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(1);
            U.writeString(out, resp.errorMessage());
            return DrNioMessageMarshaller.toByteBuffer(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR handshake response.", e);
        }
    }

    public static ByteBuffer marshal(DrExternalBatchRequest req) throws IgniteCheckedException {
        assert (req.dataBytes() != null) : "DR batch request is not prepared: " + req;
        int size = 44 + req.dataSize();
        String cacheName = req.cacheName();
        if (cacheName != null) {
            size += 4 + cacheName.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(4);
            U.writeGridUuid(out, req.requestId());
            U.writeString(out, cacheName);
            out.writeInt(req.entryCount());
            out.writeInt(req.dataSize());
            out.writeByte(req.dataCenterId());
            U.writeByteArray(out, req.dataBytes(), req.dataSize());
            return DrNioMessageMarshaller.toByteBuffer(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR batch request.", e);
        }
    }

    public static ByteBuffer marshal(DrExternalHandshakeRequest req) throws IgniteCheckedException {
        int size = 25 + req.protocolVersion().length() + req.marshallerClassName().length();
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(0);
            out.writeByte(req.dataCenterId());
            U.writeString(out, req.protocolVersion());
            U.writeString(out, req.marshallerClassName());
            out.writeBoolean(req.awaitAcknowledge());
            out.writeLong(req.getTombstoneTtl());
            return DrNioMessageMarshaller.toByteBuffer(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR handshake request.", e);
        }
    }

    public static ByteBuffer marshal(DrExternalBatchResponse resp) throws IgniteCheckedException {
        int size = 31;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(5);
            U.writeGridUuid(out, resp.requestId());
            U.writeString(out, resp.errorMessage());
            return DrNioMessageMarshaller.toByteBuffer(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR batch response.", e);
        }
    }

    public static ByteBuffer marshal(DrExternalMetadataRequest req, boolean usingBinaryMarshaller) throws IgniteCheckedException {
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(1024);
        try {
            out.writeInt(0);
            out.writeByte(6);
            out.writeLong(req.version());
            for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : req.metadata().entrySet()) {
                out.writeBoolean(true);
                out.writeUTF(entry.getKey());
                IgniteBiTuple<Byte, Integer> tup = entry.getValue().value();
                out.writeByte(tup.get1().byteValue());
                out.writeInt(tup.get2());
            }
            out.writeBoolean(false);
            if (usingBinaryMarshaller) {
                for (DrSenderMetadataHolder.Versioned versioned : req.binaryMetadata()) {
                    out.writeBoolean(true);
                    ((BinaryMetadata)versioned.value()).writeTo(out);
                }
                out.writeBoolean(false);
            }
            return DrNioMessageMarshaller.toByteBuffer(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR metadata request.", e);
        }
    }

    public static ByteBuffer marshal(DrExternalMetadataResponse resp) throws IgniteCheckedException {
        int size = 14;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(7);
            out.writeLong(resp.version());
            U.writeString(out, resp.errorMessage());
            return DrNioMessageMarshaller.toByteBuffer(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR metadata response.", e);
        }
    }

    private static ByteBuffer toByteBuffer(byte[] bytes, int size) {
        ByteBuffer buf = ByteBuffer.wrap(bytes, 0, size);
        buf.putInt(0, size - 4);
        return buf;
    }
}

