/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.future.GridCompoundIdentityFuture;
import org.apache.ignite.internal.util.lang.GridTuple4;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.dr.DrReceiverLoadBalancingMode;
import org.gridgain.grid.dr.DrSenderConnection;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionState;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCorruptedException;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreCursorClosedException;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.gridgain.grid.events.DrRemoteDcNodeEvent;
import org.gridgain.grid.events.DrRemoteDcReplicationEvent;
import org.gridgain.grid.events.DrStoreEvent;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrSenderHealthCheckScheduler;
import org.gridgain.grid.internal.processors.dr.DrSenderMetadataHolder;
import org.gridgain.grid.internal.processors.dr.DrSenderRemoteDataCenterNode;
import org.gridgain.grid.internal.processors.dr.DrSenderRequest;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMessage;
import org.gridgain.grid.internal.processors.dr.store.DrMetadataAwareStore;
import org.gridgain.grid.internal.processors.dr.store.DrStoreManager;
import org.gridgain.grid.internal.processors.dr.store.StoreListener;
import org.jetbrains.annotations.Nullable;

public class DrSenderRemoteDataCenter
implements DrSenderConnection,
StoreListener {
    @GridToStringExclude
    private final GridKernalContext ctx;
    @GridToStringExclude
    private final IgniteLogger log;
    @GridToStringExclude
    private final DrSenderConnectionConfiguration connCfg;
    @GridToStringExclude
    private final DrProcessor proc;
    private final byte dataCenterId;
    private final Collection<Byte> ignoreList;
    private final boolean awaitAck;
    private final DrReceiverLoadBalancingMode rcvHubLoadBalancingMode;
    private final List<DrSenderRemoteDataCenterNode> nodes;
    @GridToStringExclude
    private final Semaphore queueSem;
    @GridToStringExclude
    private final DrMetadataAwareStore store;
    @GridToStringExclude
    private final DrStoreManager storeMgr;
    @GridToStringExclude
    private final ConcurrentLinkedDeque<DrSenderRequest> waiting = new ConcurrentLinkedDeque();
    private final Lock stateLock = new ReentrantLock();
    private final boolean isGlobalStore;
    private final int maxQueueSize;
    private final PollBatchesFromStore pollTask = new PollBatchesFromStore();
    private volatile DataCenterState state = DataCenterState.CONNECTING;
    @GridToStringExclude
    private int connNodeCnt;
    @GridToStringExclude
    private volatile DrSenderStoreCursor storeCursor;
    @GridToStringExclude
    private int lastNodeIdx;
    private boolean dataAvailableFlag = true;
    private boolean dataProcessingScheduled;

    DrSenderRemoteDataCenter(GridKernalContext ctx, DrProcessor proc, DrSenderConnectionConfiguration connCfg, DrStoreManager storeMgr) throws IgniteCheckedException {
        assert (proc != null);
        assert (connCfg != null);
        assert (storeMgr != null);
        assert (ctx != null);
        this.proc = proc;
        this.ctx = ctx;
        this.storeMgr = storeMgr;
        this.isGlobalStore = storeMgr.isGlobalStore();
        this.log = proc.context().log(DrSenderRemoteDataCenter.class);
        this.connCfg = connCfg;
        this.maxQueueSize = proc.ggConfig().getDrSenderConfiguration().getMaxQueueSize();
        Semaphore semaphore = this.queueSem = this.maxQueueSize > 0 ? new Semaphore(this.maxQueueSize) : null;
        assert (this.maxQueueSize > 0);
        this.dataCenterId = connCfg.getDataCenterId();
        this.store = storeMgr.getStore(this.dataCenterId);
        this.ignoreList = DrSenderRemoteDataCenter.createIgnoreList(connCfg);
        this.awaitAck = connCfg.isAwaitAcknowledge();
        this.rcvHubLoadBalancingMode = connCfg.getLoadBalancingMode();
        this.nodes = Collections.unmodifiableList(this.createRemoteDCNodes(proc, connCfg));
        storeMgr.subscribeToDcUpdates(this.dataCenterId, this);
        this.store.setDrMetadataListener(this::distributeMeta);
    }

    private List<DrSenderRemoteDataCenterNode> createRemoteDCNodes(DrProcessor proc, DrSenderConnectionConfiguration connCfg) throws IgniteCheckedException {
        List<SocketAddress> locAddrs = DrSenderRemoteDataCenter.createLocalAddress(proc.config(), connCfg);
        Collection<InetSocketAddress> rmtAddrs = DrSenderRemoteDataCenter.createRemoteAddresses(connCfg);
        ArrayList<DrSenderRemoteDataCenterNode> nodes = new ArrayList<DrSenderRemoteDataCenterNode>(rmtAddrs.size());
        for (InetSocketAddress addr : rmtAddrs) {
            nodes.add(new DrSenderRemoteDataCenterNode(proc, this, locAddrs, addr));
        }
        return nodes;
    }

    private static List<SocketAddress> createLocalAddress(IgniteConfiguration cfg, DrSenderConnectionConfiguration connCfg) throws IgniteCheckedException {
        String addrStr;
        String string = addrStr = connCfg.getLocalOutboundAddress() != null ? connCfg.getLocalOutboundAddress() : connCfg.getLocalOutboundHost();
        if (addrStr == null) {
            addrStr = cfg.getLocalHost();
        }
        Address addr = DrSenderRemoteDataCenter.parseAddress(addrStr);
        ArrayList<SocketAddress> res = new ArrayList<SocketAddress>();
        String hostStr = null;
        try {
            int loPort = 0;
            int hiPort = 0;
            if (addr != null) {
                loPort = addr.loPort;
                hiPort = addr.hiPort != 0 ? addr.hiPort : addr.loPort;
                hostStr = addr.host;
            }
            InetAddress inetAddr = hostStr != null ? InetAddress.getByName(hostStr) : U.getLocalHost();
            for (int i = loPort; i <= hiPort; ++i) {
                res.add(new InetSocketAddress(inetAddr, i));
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("DR sender hub configuration parameter 'localHost' cannot be resolved to local address: " + hostStr, e);
        }
        return res;
    }

    @Nullable
    private static Address parseAddress(@Nullable String addrStr) {
        String host;
        if (addrStr == null) {
            return null;
        }
        int loPort = 0;
        int hiPort = 0;
        if (addrStr.contains(":")) {
            StringTokenizer tokenizer = new StringTokenizer(addrStr, ":");
            host = tokenizer.nextToken();
            String portStr = tokenizer.nextToken();
            String dots = "..";
            if (portStr.contains("..")) {
                loPort = Integer.parseInt(portStr.substring(0, portStr.indexOf("..")));
                hiPort = Integer.parseInt(portStr.substring(portStr.indexOf("..") + "..".length()));
            } else {
                loPort = Integer.parseInt(portStr);
            }
        } else {
            host = addrStr;
        }
        return new Address(loPort, hiPort, host);
    }

    private static Collection<InetSocketAddress> createRemoteAddresses(DrSenderConnectionConfiguration connCfg) {
        LinkedHashSet<InetSocketAddress> res = new LinkedHashSet<InetSocketAddress>();
        for (String addrStr : connCfg.getReceiverAddresses()) {
            InetSocketAddress addr;
            if (addrStr.endsWith(":")) {
                addrStr = addrStr.substring(0, addrStr.length() - 1);
            }
            if (addrStr.indexOf(58) >= 0) {
                StringTokenizer st = new StringTokenizer(addrStr, ":");
                String hostname = st.nextToken();
                int port = Integer.parseInt(st.nextToken());
                addr = new InetSocketAddress(hostname, port);
            } else {
                addr = new InetSocketAddress(addrStr, 49000);
            }
            res.add(addr);
        }
        return res;
    }

    private static Collection<Byte> createIgnoreList(DrSenderConnectionConfiguration connCfg) {
        TreeSet<Byte> res = new TreeSet<Byte>();
        res.add(connCfg.getDataCenterId());
        if (!F.isEmpty(connCfg.getIgnoredDataCenterIds())) {
            for (byte ignoredDataCenter : connCfg.getIgnoredDataCenterIds()) {
                res.add(ignoredDataCenter);
            }
        }
        return res;
    }

    public void start(GridNioServer<DrExternalMessage> srv, DrSenderHealthCheckScheduler scheduler) {
        for (DrSenderRemoteDataCenterNode node : this.nodes) {
            node.start(srv, scheduler);
        }
    }

    public void resume() {
        this.stateLock.lock();
        try {
            for (DrSenderRemoteDataCenterNode node : this.nodes) {
                node.connect();
            }
            if (this.ctx.event().isRecordable(1030)) {
                DrRemoteDcReplicationEvent evt = new DrRemoteDcReplicationEvent(this.ctx.discovery().localNode(), "Replication to remote DC has been resumed.", 1030, this.dataCenterId);
                this.ctx.event().record(evt);
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    int availablePermits() {
        return this.queueSem == null ? Integer.MAX_VALUE : this.queueSem.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.stateLock.lock();
        try {
            this.state = DataCenterState.PAUSED;
            GridCompoundIdentityFuture<Void> fut = new GridCompoundIdentityFuture<Void>();
            for (DrSenderRemoteDataCenterNode node : this.nodes) {
                fut.add(node.pause());
            }
            fut.markInitialized();
            try {
                fut.get();
            }
            catch (Exception ex) {
                U.warn(this.log, "Error during waiting for data center node become paused: " + ex);
                throw new IgniteException(ex);
            }
            if (this.ctx.event().isRecordable(1029)) {
                DrRemoteDcReplicationEvent evt = new DrRemoteDcReplicationEvent(this.ctx.discovery().localNode(), "Replication to remote DC has been paused.", 1029, this.dataCenterId);
                this.ctx.event().record(evt);
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    void stop() {
        this.storeMgr.unsubscribeFromDcUpdates(this.dataCenterId, this);
        if (this.storeCursor != null) {
            try {
                this.storeCursor.close();
            }
            catch (Exception e) {
                U.warn(this.log, "Error closing store cursor: " + e);
            }
        }
        for (DrSenderRemoteDataCenterNode node : this.nodes) {
            try {
                node.stop();
            }
            catch (Exception e) {
                U.warn(this.log, "Error closing store cursor: " + e);
            }
        }
        this.state = DataCenterState.OFFLINE;
    }

    void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> DR remote data center memory stats [rmtDataCenter=" + this + ']', new Object[0]);
        for (DrSenderRemoteDataCenterNode node : this.nodes) {
            node.printMemoryStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollBatchesFromStore() {
        boolean dataAvailableFlag0;
        DrSenderRemoteDataCenter drSenderRemoteDataCenter = this;
        synchronized (drSenderRemoteDataCenter) {
            this.dataProcessingScheduled = false;
            if (this.state != DataCenterState.ONLINE) {
                return;
            }
            dataAvailableFlag0 = this.dataAvailableFlag;
            this.dataAvailableFlag = false;
        }
        boolean storeEmpty = false;
        if (dataAvailableFlag0) {
            try {
                while (true) {
                    if (this.storeCursor == null) {
                        this.storeCursor = this.createCursor();
                    }
                    if (!this.queueSem.tryAcquire()) break;
                    try {
                        DrSenderStoreEntry storeEntry = this.storeCursor.next();
                        if (storeEntry != null) {
                            GridTuple4<IgniteUuid, String, Integer, Integer> hdr = DrUtils.batchRequestHeader(storeEntry.data());
                            assert (hdr.get3() != null);
                            assert (hdr.get4() != null);
                            DrSenderRequest sndReq = new DrSenderRequest(hdr.get1(), storeEntry, hdr.get2(), hdr.get3(), hdr.get4());
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("A DR batch has been taken from a store [cacheName=" + sndReq.cacheName() + ", reqId=" + sndReq.id() + ", targetDcId=" + this.dataCenterId + ", entriesNum=" + sndReq.entryCount() + ", dataLen=" + sndReq.byteCount() + ", fstId=" + storeEntry.stateTransferId() + "]");
                            }
                            this.waiting.addLast(sndReq);
                            continue;
                        }
                        storeEmpty = true;
                        this.queueSem.release();
                    }
                    catch (DrSenderStoreCursorClosedException e) {
                        this.storeCursor = null;
                        this.queueSem.release();
                        continue;
                    }
                    break;
                }
            }
            catch (IgniteCheckedException e) {
                if (e instanceof DrSenderStoreCorruptedException) {
                    this.recordStoreCorruptedEvt();
                }
                if (this.storeCursor != null) {
                    try {
                        this.storeCursor.close();
                    }
                    catch (Exception closeErr) {
                        U.warn(this.log, "Error closing store cursor: " + closeErr);
                    }
                    this.storeCursor = null;
                }
                U.error(this.log, "Failed to read data from store, sender hub has stopped accepting requests. Full state transfer is needed.", e);
                throw new IgniteException(e);
            }
        }
        this.distributeWaitingBatches();
        DrSenderRemoteDataCenter drSenderRemoteDataCenter2 = this;
        synchronized (drSenderRemoteDataCenter2) {
            if (!storeEmpty) {
                this.dataAvailableFlag = true;
            }
            if (this.dataAvailableFlag) {
                this.trySubmitPollTask();
            }
        }
    }

    private DrSenderStoreCursor createCursor() throws IgniteCheckedException {
        return this.storeMgr.createCursor(this.dataCenterId);
    }

    private void distributeMeta(DrSenderMetadataHolder meta) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            DrSenderRemoteDataCenterNode n = this.nodes.get(i);
            n.sendMetaIfNeeded(meta);
        }
    }

    private void distributeWaitingBatches() {
        DrSenderRequest entry;
        if (this.waiting.isEmpty()) {
            return;
        }
        while ((entry = this.waiting.poll()) != null) {
            DrSenderRemoteDataCenterNode node = this.nextBalancedNode();
            if (node == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send outgoing message since no sender node available.");
                }
                this.waiting.addFirst(entry);
                break;
            }
            node.enqueueOutMessage(entry);
        }
        for (DrSenderRemoteDataCenterNode node : this.nodes) {
            node.sendMetaIfNeeded(null);
            node.sendRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchAdded() {
        DrSenderRemoteDataCenter drSenderRemoteDataCenter = this;
        synchronized (drSenderRemoteDataCenter) {
            if (!this.dataAvailableFlag) {
                this.dataAvailableFlag = true;
                this.trySubmitPollTask();
            }
        }
    }

    private void trySubmitPollTask() {
        assert (Thread.holdsLock(this));
        if (!this.dataProcessingScheduled) {
            this.proc.senderHub().submit(this.pollTask);
            this.dataProcessingScheduled = true;
        }
    }

    void reset() {
        this.waiting.clear();
        if (this.storeCursor != null) {
            try {
                this.storeCursor.close();
            }
            catch (Exception e) {
                U.warn(this.log, "Error closing store cursor: " + e);
            }
            this.storeCursor = null;
        }
        if (this.queueSem != null) {
            this.queueSem.drainPermits();
            this.queueSem.release(this.maxQueueSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResponse(IgniteUuid id, DrSenderRequest req) {
        assert (req != null);
        assert (F.eq(id, req.id()));
        req.storeEntry().acknowledge(this.dataCenterId);
        if (this.queueSem != null) {
            this.queueSem.release();
            DrSenderRemoteDataCenter drSenderRemoteDataCenter = this;
            synchronized (drSenderRemoteDataCenter) {
                if (this.dataAvailableFlag) {
                    this.trySubmitPollTask();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReject(DrSenderRequest req) {
        this.waiting.add(req);
        this.proc.metrics().onSenderHubBatchFailed(this.dataCenterId, req.cacheName(), req.entryCount(), req.data().length);
        DrSenderRemoteDataCenter drSenderRemoteDataCenter = this;
        synchronized (drSenderRemoteDataCenter) {
            this.dataAvailableFlag = true;
            this.trySubmitPollTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeConnect(DrSenderRemoteDataCenterNode rmtNode) {
        block8: {
            ++this.connNodeCnt;
            this.recordRemoteDcNodeEvt(1020, rmtNode.rmtAddr());
            this.stateLock.lock();
            try {
                if (this.state == DataCenterState.ONLINE) break block8;
                this.state = DataCenterState.ONLINE;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Remote data center switched to online mode: " + this);
                }
                DrSenderRemoteDataCenter drSenderRemoteDataCenter = this;
                synchronized (drSenderRemoteDataCenter) {
                    if (this.dataAvailableFlag) {
                        this.trySubmitPollTask();
                    }
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeDisconnect(DrSenderRemoteDataCenterNode rmtNode, boolean decrement) {
        if (decrement) {
            --this.connNodeCnt;
            this.recordRemoteDcNodeEvt(1021, rmtNode.rmtAddr());
        }
        if (this.connNodeCnt == 0 && this.state != DataCenterState.OFFLINE && this.state != DataCenterState.PAUSED) {
            boolean offline = true;
            for (DrSenderRemoteDataCenterNode node : this.nodes) {
                if (node.isCrashed() || node.isPaused()) continue;
                offline = false;
                break;
            }
            if (offline) {
                this.stateLock.lock();
                try {
                    this.state = DataCenterState.OFFLINE;
                    this.reset();
                }
                finally {
                    this.stateLock.unlock();
                }
                U.warn(this.log, "Replica switched to offline mode: " + this);
            } else if (this.state == DataCenterState.ONLINE) {
                this.state = DataCenterState.CONNECTING;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Remote data center switched to connecting mode: " + this);
                }
            }
        }
    }

    private void recordRemoteDcNodeEvt(int type, InetSocketAddress rmtAddr) {
        if (!this.ctx.event().isUserRecordable(type)) {
            return;
        }
        ClusterNode node = this.ctx.discovery().localNode();
        String msg = null;
        switch (type) {
            case 1020: {
                msg = "DC receiver connected.";
                break;
            }
            case 1021: {
                msg = "DC receiver disconnected";
                break;
            }
            default: {
                assert (false) : "Unsupported event type " + type;
                break;
            }
        }
        this.ctx.event().record(new DrRemoteDcNodeEvent(node, msg, type, rmtAddr, this.dataCenterId, this.connNodeCnt));
    }

    private void recordStoreCorruptedEvt() {
        ClusterNode node = this.ctx.discovery().localNode();
        if (this.ctx.event().isUserRecordable(1027)) {
            this.ctx.event().record(new DrStoreEvent(node, "Store corrupted.", 1027, this.isGlobalStore ? null : Byte.valueOf(this.dataCenterId)));
        }
    }

    @Nullable
    private DrSenderRemoteDataCenterNode nextBalancedNode() {
        if (this.state != DataCenterState.ONLINE) {
            return null;
        }
        if (this.nodes.size() == 1) {
            return this.nodes.get(0).isConnected() ? this.nodes.get(0) : null;
        }
        switch (this.rcvHubLoadBalancingMode) {
            case DR_ROUND_ROBIN: {
                int size = this.nodes.size();
                assert (size > 0);
                int stopIdx = this.lastNodeIdx;
                do {
                    this.lastNodeIdx = this.lastNodeIdx < size - 1 ? this.lastNodeIdx + 1 : 0;
                    DrSenderRemoteDataCenterNode node = this.nodes.get(this.lastNodeIdx);
                    if (!node.isConnected()) continue;
                    return node;
                } while (this.lastNodeIdx != stopIdx);
                break;
            }
            default: {
                assert (this.rcvHubLoadBalancingMode == DrReceiverLoadBalancingMode.DR_RANDOM);
                ArrayList<DrSenderRemoteDataCenterNode> nodes0 = null;
                for (int i = 0; i < this.nodes.size(); ++i) {
                    DrSenderRemoteDataCenterNode node = this.nodes.get(i);
                    if (!node.isConnected()) continue;
                    if (nodes0 == null) {
                        nodes0 = new ArrayList<DrSenderRemoteDataCenterNode>();
                    }
                    nodes0.add(node);
                }
                if (F.isEmpty(nodes0)) break;
                return (DrSenderRemoteDataCenterNode)nodes0.get(ThreadLocalRandom.current().nextInt(nodes0.size()));
            }
        }
        return null;
    }

    Collection<Byte> ignoreList() {
        return this.ignoreList;
    }

    boolean awaitAcknowledge() {
        return this.awaitAck;
    }

    public DrSenderStore getStore() {
        return this.store.getStore();
    }

    DrSenderMetadataHolder getMetadata(long metaVer) {
        return this.store.getMetadata(metaVer);
    }

    @Override
    public byte dataCenterId() {
        return this.dataCenterId;
    }

    @Override
    public DrSenderConnectionState connectionState() {
        return this.state == DataCenterState.ONLINE ? DrSenderConnectionState.CONNECTED : DrSenderConnectionState.DISCONNECTED;
    }

    @Override
    public boolean paused() {
        return this.state == DataCenterState.PAUSED;
    }

    @Override
    public boolean isStoreOverflow() {
        return this.store.isOverflow();
    }

    @Override
    public DrSenderConnectionConfiguration getConfiguration() {
        return this.connCfg;
    }

    @Override
    public void clearStore() {
        if (this.proc.senderHub().isGlobalStore()) {
            throw new IllegalStateException("Failed to clear connection store because global store is configured for this sender hub.");
        }
        try {
            this.pause();
            this.store.clear();
            this.reset();
            this.resume();
        }
        catch (Exception e) {
            throw new IgniteException("Failed to clear connection store [dataCenterId=" + this.dataCenterId + ", store=" + this.store, e);
        }
    }

    public String toString() {
        Factory<SSLContext> sslFactory = this.proc.getSslContextFactory(this.proc.ggConfig().getDrSenderConfiguration());
        if (sslFactory == null) {
            return S.toString(DrSenderRemoteDataCenter.class, this, "sslEnabled", (Object)false);
        }
        return S.toString(DrSenderRemoteDataCenter.class, this, "sslEnabled", (Object)true, "sslProto", (Object)sslFactory.create().getProtocol(), "defaultSslFactory", (Object)this.proc.ggConfig().getDrSenderConfiguration().isUseIgniteSslContextFactory());
    }

    public class PollBatchesFromStore
    implements Runnable {
        @Override
        public void run() {
            DrSenderRemoteDataCenter.this.pollBatchesFromStore();
        }
    }

    private static class Address {
        private final int loPort;
        private final int hiPort;
        private final String host;

        Address(int loPort, int hiPort, String host) {
            this.loPort = loPort;
            this.hiPort = hiPort;
            this.host = host;
        }
    }

    private static enum DataCenterState {
        OFFLINE,
        PAUSED,
        CONNECTING,
        ONLINE;

        private static final DataCenterState[] VALS;

        @Nullable
        public static DataCenterState fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = DataCenterState.values();
        }
    }
}

