/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderOutCacheMetrics;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsAdapter;

class DrSenderOutCacheMetricsAdapter
extends DrAbstractMetricsAdapter
implements DrSenderOutCacheMetrics {
    private static final String DR_SENDER_OUT_REG_NAME = "sender.";
    private final LongAdderMetric batchesSent;
    private final LongAdderMetric entriesSent;
    private final LongAdderMetric bytesSent;
    private final LongAdderMetric batchesAcked;
    private final LongAdderMetric entriesAcked;
    private final LongAdderMetric bytesAcked;
    private final LongAdderMetric ackSndTime;
    private final LongAdderMetric batchesFailed;
    private final LongAdderMetric entriesFailed;
    private final LongAdderMetric bytesFailed;

    DrSenderOutCacheMetricsAdapter(GridKernalContext ctx, byte dcId, String cacheName) {
        super(ctx, "sender.dc" + dcId + "." + cacheName);
        this.batchesSent = this.reg.longAdderMetric("BatchesSent", "Amount of batches sent to receiver hubs.");
        this.entriesSent = this.reg.longAdderMetric("EntriesSent", "Amount of entries sent to receiver hubs.");
        this.bytesSent = this.reg.longAdderMetric("BytesSent", "Amount of bytes sent to receiver hubs.");
        this.batchesAcked = this.reg.longAdderMetric("BatchesAcked", "Amount of sent batches with received acknowledgement from receiver hubs.");
        this.entriesAcked = this.reg.longAdderMetric("EntriesAcked", "Amount of sent entries with received acknowledgement from receiver hubs.");
        this.bytesAcked = this.reg.longAdderMetric("BytesAcked", "Amount of sent bytes with received acknowledgement from receiver hubs.");
        this.batchesFailed = this.reg.longAdderMetric("BatchesFailed", "Amount of failed batches with received failed acknowledgement from receiver hubs or re-sent on disconnect.");
        this.entriesFailed = this.reg.longAdderMetric("EntriesFailed", "Amount of failed entries with received failed acknowledgement from receiver hubs or re-sent on disconnect.");
        this.bytesFailed = this.reg.longAdderMetric("BytesFailed", "Amount of failed bytes with received failed acknowledgement from receiver hubs or re-sent on disconnect.");
        this.ackSndTime = this.reg.longAdderMetric("AckSndTime", "Total acknowledgement sent time in milliseconds.on disconnect.");
        this.reg.register("AverageBatchAckTime", this::averageBatchAckTime, "Average time in milliseconds between sending batch for the first time and receiving acknowledgement it.");
    }

    @Override
    public int batchesSent() {
        return (int)this.batchesSent.value();
    }

    @Override
    public long entriesSent() {
        return this.entriesSent.value();
    }

    @Override
    public long bytesSent() {
        return this.bytesSent.value();
    }

    @Override
    public int batchesAcked() {
        return (int)this.batchesAcked.value();
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked.value();
    }

    @Override
    public long bytesAcked() {
        return this.bytesAcked.value();
    }

    @Override
    public double averageBatchAckTime() {
        long acked = this.batchesAcked();
        return acked > 0L ? (double)this.ackSendTime() * 1.0 / (double)acked : 0.0;
    }

    public long batchesFailed() {
        return this.batchesFailed.value();
    }

    public long entriesFailed() {
        return this.entriesFailed.value();
    }

    public long getBytesFailed() {
        return this.bytesFailed.value();
    }

    long ackSendTime() {
        return this.ackSndTime.value();
    }

    void onBatchSent(int entryCnt, int byteCnt) {
        this.batchesSent.increment();
        this.entriesSent.add(entryCnt);
        this.bytesSent.add(byteCnt);
    }

    void onBatchAcked(int entryCnt, int byteCnt, long spentTime) {
        this.batchesAcked.increment();
        this.entriesAcked.add(entryCnt);
        this.bytesAcked.add(byteCnt);
        this.ackSndTime.add(spentTime);
    }

    void onBatchFailed(int entryCnt, int byteCnt) {
        this.batchesFailed.increment();
        this.entriesFailed.add(entryCnt);
        this.bytesFailed.add(byteCnt);
    }

    @Override
    public String toString() {
        return S.toString(DrSenderOutCacheMetricsAdapter.class, this);
    }
}

