/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsAdapter;

class DrSenderInMetricsAdapter
extends DrAbstractMetricsAdapter
implements DrSenderInMetrics {
    private static final String DR_SENDER_IN_REG_NAME = "sender.";
    private final LongAdderMetric batchesReceived;
    private final LongAdderMetric entriesReceived;
    private final LongAdderMetric bytesReceived;
    private final LongAdderMetric entriesFiltered;
    private final LongAdderMetric bytesFiltered;
    private final LongAdderMetric batchesRejected;

    DrSenderInMetricsAdapter(GridKernalContext ctx, String cacheName) {
        super(ctx, DR_SENDER_IN_REG_NAME + cacheName);
        this.batchesReceived = this.reg.longAdderMetric("BatchesReceived", "Amount of batches received from sender caches.");
        this.entriesReceived = this.reg.longAdderMetric("EntriesReceived", "Amount of cache entries received from sender caches.");
        this.bytesReceived = this.reg.longAdderMetric("BytesReceived", "Amount of bytes received from sender caches.");
        this.entriesFiltered = this.reg.longAdderMetric("EntriesFiltered", "Amount of cache entries filtered (received from cache but not stored, e.g. when target data center ID equals source data center ID) on sender side.");
        this.bytesFiltered = this.reg.longAdderMetric("BytesFiltered", "Amount of cache entries filtered (received from cache but not stored, e.g. when entry's target data center ID equals source data center ID) on sender side.");
        this.batchesRejected = this.reg.longAdderMetric("BatchesRejected", "Amount of rejected batches.");
    }

    @Override
    public int batchesReceived() {
        return (int)this.batchesReceived.value();
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived.value();
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived.value();
    }

    @Override
    public int batchesRejected() {
        return (int)this.batchesRejected.value();
    }

    void onBatchReceived(long entryCnt, long bytesCnt) {
        this.batchesReceived.increment();
        this.entriesReceived.add(entryCnt);
        this.bytesReceived.add(bytesCnt);
    }

    void onEntriesFiltered(long entryCnt, long bytesCnt) {
        this.entriesFiltered.add(entryCnt);
        this.bytesFiltered.add(bytesCnt);
    }

    void onBatchRejected() {
        this.batchesRejected.increment();
    }

    @Override
    public String toString() {
        return S.toString(DrSenderInMetricsAdapter.class, this);
    }
}

