/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrReceiverCacheMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverOutMetricsAdapter;
import org.jetbrains.annotations.Nullable;

class DrReceiverOutMetricsAggregate
implements DrReceiverOutMetrics {
    private long batchesAcked;
    private long entriesAcked;
    private long bytesAcked;
    private long batchesSent;
    private long entriesSent;
    private long bytesSent;
    private long ackSndTime;

    public DrReceiverOutMetricsAggregate() {
    }

    public DrReceiverOutMetricsAggregate(@Nullable DrReceiverOutMetricsAdapter m4) {
        if (m4 != null) {
            this.batchesAcked = m4.batchesAcked();
            this.entriesAcked = m4.entriesAcked();
            this.bytesAcked = m4.bytesAcked();
            this.batchesSent = m4.batchesSent();
            this.entriesSent = m4.entriesSent();
            this.bytesSent = m4.bytesSent();
            this.ackSndTime = m4.ackSendTime();
        }
    }

    public DrReceiverOutMetricsAggregate(@Nullable DrReceiverCacheMetricsAdapter m4) {
        if (m4 != null) {
            this.batchesAcked = m4.batchesAcked();
            this.entriesAcked = m4.entriesAcked();
            this.bytesAcked = m4.bytesAcked();
            this.batchesSent = m4.batchesSent();
            this.entriesSent = m4.entriesSent();
            this.bytesSent = m4.bytesSent();
            this.ackSndTime = m4.ackSendTime();
        }
    }

    @Override
    public int batchesAcked() {
        return (int)this.batchesAcked;
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked;
    }

    @Override
    public long bytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public int batchesSent() {
        return (int)this.batchesSent;
    }

    @Override
    public long entriesSent() {
        return this.entriesSent;
    }

    @Override
    public long bytesSent() {
        return this.bytesSent;
    }

    @Override
    public double averageBatchAckTime() {
        int batches = this.batchesAcked();
        return batches > 0 ? (double)this.ackSndTime * 1.0 / (double)batches : 0.0;
    }

    public void aggregate(DrReceiverOutMetricsAdapter m4) {
        if (m4 != null) {
            this.batchesAcked += (long)m4.batchesAcked();
            this.entriesAcked += m4.entriesAcked();
            this.bytesAcked += m4.bytesAcked();
            this.batchesSent += (long)m4.batchesSent();
            this.entriesSent += m4.entriesSent();
            this.bytesSent += m4.bytesSent();
            this.ackSndTime += m4.ackSendTime();
        }
    }

    public String toString() {
        return S.toString(DrReceiverOutMetricsAggregate.class, this);
    }
}

