/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsAdapter;

class DrReceiverOutMetricsAdapter
extends DrAbstractMetricsAdapter
implements DrReceiverOutMetrics {
    private static final String DR_RECEIVER_OUT_REG_NAME = "receiver.";
    private final LongAdderMetric batchesAcked;
    private final LongAdderMetric entriesAcked;
    private final LongAdderMetric bytesAcked;
    private final LongAdderMetric batchesSent;
    private final LongAdderMetric entriesSent;
    private final LongAdderMetric bytesSent;
    private final LongAdderMetric ackSndTime;

    DrReceiverOutMetricsAdapter(GridKernalContext ctx, String cacheName) {
        super(ctx, DR_RECEIVER_OUT_REG_NAME + cacheName);
        this.batchesAcked = this.reg.longAdderMetric("BatchesAcked", "Amount of batches stored in receiver caches.");
        this.entriesAcked = this.reg.longAdderMetric("EntriesAcked", "Amount of entries stored in receiver caches.");
        this.bytesAcked = this.reg.longAdderMetric("BytesAcked", "Amount of bytes stored in receiver caches.");
        this.batchesSent = this.reg.longAdderMetric("BatchesSent", "Amount of batches waiting to be stored in receiver caches.");
        this.entriesSent = this.reg.longAdderMetric("EntriesSent", "Amount of entries waiting to be stored in receiver caches.");
        this.bytesSent = this.reg.longAdderMetric("BytesSent", "Amount of bytes waiting to be stored in receiver caches.");
        this.ackSndTime = this.reg.longAdderMetric("AckSndTime", "Total acknowledgment sent time in milliseconds.");
        this.reg.register("AverageBatchAckTime", this::averageBatchAckTime, "Amount of bytes waiting to be stored in receiver caches.");
    }

    @Override
    public int batchesAcked() {
        return (int)this.batchesAcked.value();
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked.value();
    }

    @Override
    public long bytesAcked() {
        return this.bytesAcked.value();
    }

    @Override
    public int batchesSent() {
        return (int)this.batchesSent.value();
    }

    @Override
    public long entriesSent() {
        return this.entriesSent.value();
    }

    @Override
    public long bytesSent() {
        return this.bytesSent.value();
    }

    @Override
    public double averageBatchAckTime() {
        long batches = this.batchesAcked();
        return batches > 0L ? (double)this.ackSndTime.value() * 1.0 / (double)batches : 0.0;
    }

    long ackSendTime() {
        return this.ackSndTime.value();
    }

    public void onBatchSent(int entryCnt, long byteCnt) {
        this.batchesSent.increment();
        this.entriesSent.add(entryCnt);
        this.bytesSent.add(byteCnt);
    }

    public void onBatchAcked(int entryCnt, long byteCnt, long spentTime) {
        this.batchesAcked.increment();
        this.ackSndTime.add(spentTime);
        this.entriesAcked.add(entryCnt);
        this.bytesAcked.add(byteCnt);
    }

    @Override
    public String toString() {
        return S.toString(DrReceiverOutMetricsAdapter.class, this);
    }
}

