/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

class DrReceiverMetadataManager {
    private ConcurrentMap<Long, MetaWrapper> metas = new ConcurrentHashMap<Long, MetaWrapper>();
    private GridKernalContext ctx;
    private IgniteLogger log;

    DrReceiverMetadataManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(DrReceiverMetadataManager.class);
    }

    private void registerTypesAndSchemas(Long typeWithSchema, BinaryMetadata meta) {
        this.metas.compute(typeWithSchema, (k, wrp) -> {
            if (wrp != null) {
                if (((MetaWrapper)wrp).isAwaiting()) {
                    ((MetaWrapper)wrp).registerMetadata(meta);
                    for (Object obj : ((MetaWrapper)wrp).waitingQueue()) {
                        if (F.isEmpty(((MetaWrapper)wrp).objFieldIds) || !(obj instanceof BinaryObjectExImpl)) continue;
                        BinaryObjectExImpl boEx = (BinaryObjectExImpl)obj;
                        boolean findSchema = false;
                        for (BinarySchema sc : meta.schemas()) {
                            if (sc.schemaId() != boEx.schemaId()) continue;
                            findSchema = true;
                            break;
                        }
                        if (!findSchema) {
                            this.log.warning("Schema id=" + boEx.schemaId() + " still not registered for typeId=" + boEx.typeId());
                        }
                        ((MetaWrapper)wrp).checkFields(boEx);
                    }
                    ((MetaWrapper)wrp).clearWaitingQueue();
                } else {
                    ((MetaWrapper)wrp).updateMeta(meta);
                }
                return wrp;
            }
            return new MetaWrapper(meta);
        });
    }

    public void updateMetadata(BinaryMetadata meta) {
        int typeId = meta.typeId();
        if (meta.schemas().isEmpty()) {
            this.registerTypesAndSchemas(Long.valueOf(typeId), meta);
        } else {
            Collection schemas = meta.schemas().stream().map(BinarySchema::schemaId).collect(Collectors.toList());
            for (Integer schemaId : schemas) {
                Long typeWithSchema = (long)schemaId.intValue() << 32 | (long)typeId & 0xFFFFFFFFL;
                this.registerTypesAndSchemas(typeWithSchema, meta);
            }
        }
    }

    public void registerMetadataIfNeed(Object obj) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        long typeWithSchema;
                        if (obj == null) {
                            return;
                        }
                        if (!(obj instanceof BinaryObject)) break block6;
                        BinaryObject bo = (BinaryObject)obj;
                        int typeId = bo.type().typeId();
                        if (obj instanceof BinaryObjectExImpl) {
                            int schemaId = ((BinaryObjectExImpl)obj).schemaId();
                            typeWithSchema = (long)schemaId << 32 | (long)typeId & 0xFFFFFFFFL;
                        } else {
                            typeWithSchema = (long)typeId & 0xFFFFFFFFL;
                        }
                        this.metas.compute(typeWithSchema, (k, v) -> {
                            if (v != null) {
                                if (((MetaWrapper)v).isAwaiting()) {
                                    ((MetaWrapper)v).register(obj);
                                } else {
                                    ((MetaWrapper)v).registerMeta();
                                    assert (((MetaWrapper)v).waitingQueue().size() <= 1) : "Unexpected awaiting registration queue size.";
                                    if (!F.isEmpty(((MetaWrapper)v).objFieldIds) && obj instanceof BinaryObjectExImpl) {
                                        ((MetaWrapper)v).checkFields((BinaryObjectExImpl)obj);
                                    }
                                    ((MetaWrapper)v).clearWaitingQueue();
                                }
                                return v;
                            }
                            return new MetaWrapper(obj);
                        });
                        break block7;
                    }
                    if (!(obj instanceof Map)) break block8;
                    for (Map.Entry e : ((Map)obj).entrySet()) {
                        this.registerMetadataIfNeed(e.getKey());
                        this.registerMetadataIfNeed(e.getValue());
                    }
                    break block7;
                }
                if (!(obj instanceof Object[])) break block9;
                for (Object o : (Object[])obj) {
                    this.registerMetadataIfNeed(o);
                }
                break block7;
            }
            if (!(obj instanceof Collection)) break block7;
            for (Object o : (Iterable)obj) {
                this.registerMetadataIfNeed(o);
            }
        }
    }

    private static int[] fieldIds(BinaryMetadata meta) {
        ArrayList<Integer> flds = new ArrayList<Integer>();
        for (BinaryFieldMetadata fld : meta.fieldsMap().values()) {
            int fldTypeId = fld.typeId();
            if (fldTypeId != 27 && fldTypeId != 103 && fldTypeId != 28 && fldTypeId != 38 && fldTypeId != 29 && fldTypeId != 24 && fldTypeId != 25 && fldTypeId != 23) continue;
            flds.add(fld.fieldId());
        }
        return flds.stream().mapToInt(id -> id).toArray();
    }

    private static void registerMeta(GridKernalContext ctx, BinaryMetadata m4) {
        CacheObjectBinaryProcessorImpl binaryProcessor = (CacheObjectBinaryProcessorImpl)ctx.cacheObjects();
        binaryProcessor.addMeta(m4.typeId(), m4.wrap(binaryProcessor.binaryContext()), false);
    }

    class MetaWrapper {
        private BinaryMetadata meta;
        private int[] objFieldIds;
        private boolean awaiting;
        @GridToStringExclude
        private Set<Object> holder = Collections.emptySet();

        MetaWrapper(BinaryMetadata meta) {
            this.meta = meta;
            this.objFieldIds = DrReceiverMetadataManager.fieldIds(meta);
        }

        MetaWrapper(Object obj) {
            this.awaiting = true;
            if (obj instanceof BinaryObjectExImpl) {
                this.holder = new HashSet<Object>(Collections.singleton(obj));
            }
        }

        private void registerMetadata(BinaryMetadata meta) {
            assert (this.meta == null && this.awaiting) : "Metadata already registered.";
            this.meta = meta;
            this.objFieldIds = DrReceiverMetadataManager.fieldIds(meta);
            this.awaiting = false;
            this.registerMeta();
        }

        private void register(Object obj) {
            if (!(obj instanceof BinaryObjectExImpl)) {
                return;
            }
            this.holder.add(obj);
        }

        private void registerMeta() {
            DrReceiverMetadataManager.registerMeta(DrReceiverMetadataManager.this.ctx, this.meta);
        }

        private void updateMeta(BinaryMetadata newMeta) {
            assert (!this.awaiting) : "Wrong execution path, incorrect update.";
            BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(this.meta, newMeta);
            if (mergedMeta != this.meta) {
                DrReceiverMetadataManager.registerMeta(DrReceiverMetadataManager.this.ctx, mergedMeta);
                this.meta = mergedMeta;
                this.objFieldIds = DrReceiverMetadataManager.fieldIds(mergedMeta);
            }
        }

        private void checkFields(BinaryObjectExImpl bo) {
            for (int id : this.objFieldIds) {
                DrReceiverMetadataManager.this.registerMetadataIfNeed(bo.fieldNoHandle(id));
            }
        }

        private Collection<Object> waitingQueue() {
            return this.holder;
        }

        private void clearWaitingQueue() {
            this.holder = Collections.emptySet();
        }

        private boolean isAwaiting() {
            return this.awaiting;
        }

        public String toString() {
            return S.toString(MetaWrapper.class, this);
        }
    }
}

