/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverCacheMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverInCacheMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrReceiverOutMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverOutMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrSenderInMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrSenderInMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrSenderOutCacheMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrSenderOutCacheMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrSenderOutMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrSenderStoreMetricsAdapter;
import org.jetbrains.annotations.Nullable;

public class DrMetricsManager {
    private GridKernalContext ctx;
    private ConcurrentHashMap<String, DrSenderInMetricsAdapter> sndHubInMetrics;
    private ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter>[] sndHubOutMetrics;
    private ConcurrentHashMap<String, DrReceiverCacheMetricsAdapter>[] rcvHubCacheMetrics;
    private ConcurrentHashMap<String, DrReceiverOutMetricsAdapter> rcvHubOutMetrics;
    private Map<Byte, DrSenderStoreMetricsAdapter> sndOutDcStoreMetrics = new HashMap<Byte, DrSenderStoreMetricsAdapter>();
    private DrSenderStoreMetricsAdapter sndOutGlobalStoreMetrics;
    private DrSenderStoreMetricsAdapter sndGlobalFstBufferMetrics;
    private DrReceiverInMetricsAdapter rcvInMetrics;
    private final Object mux = new Object();
    private volatile boolean stopped;

    DrMetricsManager(GridKernalContext ctx, GridGainConfiguration cfg) {
        DrReceiverConfiguration rcvCfg;
        assert (cfg != null);
        this.ctx = ctx;
        DrSenderConfiguration sndCfg = cfg.getDrSenderConfiguration();
        if (sndCfg != null) {
            this.sndHubInMetrics = new ConcurrentHashMap();
            this.sndHubOutMetrics = new ConcurrentHashMap[32];
            for (DrSenderConnectionConfiguration rmtCfg : sndCfg.getConnectionConfiguration()) {
                this.sndHubOutMetrics[rmtCfg.getDataCenterId()] = new ConcurrentHashMap();
            }
        }
        if ((rcvCfg = cfg.getDrReceiverConfiguration()) != null) {
            this.rcvHubCacheMetrics = new ConcurrentHashMap[32];
            for (int i = 0; i < 32; ++i) {
                this.rcvHubCacheMetrics[i] = new ConcurrentHashMap();
            }
            this.rcvHubOutMetrics = new ConcurrentHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSenderDcStoreMetrics(byte dcId, LongSupplier storeSizeSup) {
        Object object = this.mux;
        synchronized (object) {
            DrSenderStoreMetricsAdapter m4 = new DrSenderStoreMetricsAdapter(this.ctx, "sender.store.dc" + dcId, storeSizeSup);
            this.sndOutDcStoreMetrics.put(dcId, m4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSenderGlobalStoreMetrics(LongSupplier storeSizeSup) {
        Object object = this.mux;
        synchronized (object) {
            assert (Objects.isNull(this.sndOutGlobalStoreMetrics));
            this.sndOutGlobalStoreMetrics = new DrSenderStoreMetricsAdapter(this.ctx, "sender.store.global", storeSizeSup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSenderGlobalStateTransferBufferMetrics(LongSupplier storeSizeSup) {
        Object object = this.mux;
        synchronized (object) {
            assert (Objects.isNull(this.sndGlobalFstBufferMetrics));
            this.sndGlobalFstBufferMetrics = new DrSenderStoreMetricsAdapter(this.ctx, "sender.buffer.global", storeSizeSup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrReceiverInMetricsAdapter registerReceiverMetrics() {
        Object object = this.mux;
        synchronized (object) {
            if (this.rcvInMetrics == null) {
                this.rcvInMetrics = new DrReceiverInMetricsAdapter(this.ctx);
            } else {
                this.rcvInMetrics.reset();
            }
            return this.rcvInMetrics;
        }
    }

    DrSenderInMetrics senderHubInMetrics(@Nullable String cacheName) {
        if (this.sndHubInMetrics != null) {
            DrSenderInMetricsAdapter metrics = this.senderHubInMetrics0(cacheName, false);
            return new DrSenderInMetricsAggregate(metrics);
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderInMetrics senderHubInMetrics() {
        if (this.sndHubInMetrics != null) {
            DrSenderInMetricsAggregate metricAgg = new DrSenderInMetricsAggregate();
            this.sndHubInMetrics.values().forEach(metricAgg::aggregate);
            return metricAgg;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetrics senderHubOutMetrics(byte destDataCenterId, @Nullable String cacheName) {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, false);
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metrics);
            res.storeSize(this.storeSizeBytes(destDataCenterId));
            res.stateTransferBufferSize(this.stateTransferBufferSizeBytes());
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetricsHolder senderHubOutMetrics(byte destDataCenterId) {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAggregate metricsAgg = new DrSenderOutCacheMetricsAggregate();
            ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter> metricsMap = this.sndHubOutMetrics[destDataCenterId];
            if (metricsMap == null) {
                throw new IllegalArgumentException("Sender hub doesn't work with data center: " + destDataCenterId);
            }
            metricsMap.values().forEach(metricsAgg::aggregate);
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metricsAgg);
            res.storeSize(this.storeSizeBytes(destDataCenterId));
            res.stateTransferBufferSize(this.stateTransferBufferSizeBytes());
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetricsHolder senderHubOutMetrics(@Nullable String cacheName) {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAggregate metricsAgg = new DrSenderOutCacheMetricsAggregate();
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).map(map -> (DrSenderOutCacheMetricsAdapter)map.get(cacheName)).filter(Objects::nonNull).forEach(metricsAgg::aggregate);
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metricsAgg);
            res.storeSize(this.storeSizeBytes(null));
            res.stateTransferBufferSize(this.stateTransferBufferSizeBytes());
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetricsHolder senderHubOutMetrics() {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAggregate metricsAgg = new DrSenderOutCacheMetricsAggregate();
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).forEach(map -> map.values().forEach(metricsAgg::aggregate));
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metricsAgg);
            res.storeSize(this.storeSizeBytes(null));
            res.stateTransferBufferSize(this.stateTransferBufferSizeBytes());
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics(byte srcDataCenterId, @Nullable String cacheName) {
        if (this.rcvHubCacheMetrics != null) {
            DrReceiverCacheMetricsAdapter metrics = this.receiverHubCacheMetrics0(srcDataCenterId, cacheName, false);
            DrReceiverInCacheMetricsAggregate metricsAgg = new DrReceiverInCacheMetricsAggregate(metrics);
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricsAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.messageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics(byte srcDataCenterId) {
        if (this.rcvHubCacheMetrics != null) {
            DrReceiverInCacheMetricsAggregate metricAgg = new DrReceiverInCacheMetricsAggregate();
            ConcurrentHashMap<String, DrReceiverCacheMetricsAdapter> metricsMap = this.rcvHubCacheMetrics[srcDataCenterId];
            metricsMap.values().stream().forEach(metricAgg::aggregate);
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.messageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics(@Nullable String cacheName) {
        if (this.rcvHubCacheMetrics != null) {
            DrReceiverInCacheMetricsAggregate metricAgg = new DrReceiverInCacheMetricsAggregate();
            for (byte i = 0; i < 32; i = (byte)(i + 1)) {
                DrReceiverCacheMetricsAdapter metrics = this.receiverHubCacheMetrics0(i, cacheName, false);
                metricAgg.aggregate(metrics);
            }
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.messageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics() {
        if (this.rcvHubCacheMetrics != null) {
            DrReceiverInCacheMetricsAggregate metricAgg = new DrReceiverInCacheMetricsAggregate();
            Arrays.stream(this.rcvHubCacheMetrics).forEach(map -> map.values().forEach(metricAgg::aggregate));
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.messageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverOutMetrics receiverHubOutMetrics(String cacheName) {
        if (this.rcvHubOutMetrics != null) {
            DrReceiverOutMetricsAdapter metrics = this.receiverHubOutMetrics0(cacheName, false);
            return new DrReceiverOutMetricsAggregate(metrics);
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverOutMetrics receiverHubOutMetrics(byte srcDataCenterId, String cacheName) {
        if (this.rcvHubCacheMetrics != null) {
            DrReceiverCacheMetricsAdapter metrics = this.receiverHubCacheMetrics0(srcDataCenterId, cacheName, false);
            return new DrReceiverOutMetricsAggregate(metrics);
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverOutMetrics receiverHubOutMetrics() {
        if (this.rcvHubOutMetrics != null) {
            DrReceiverOutMetricsAggregate metricAgg = new DrReceiverOutMetricsAggregate();
            this.rcvHubOutMetrics.values().forEach(metricAgg::aggregate);
            return metricAgg;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    @Nullable
    private DrReceiverCacheMetricsAdapter receiverHubCacheMetrics0(byte srcDataCenterId, @Nullable String cacheName, boolean create) {
        if (this.rcvHubCacheMetrics != null) {
            ConcurrentHashMap<String, DrReceiverCacheMetricsAdapter> metricsMap = this.rcvHubCacheMetrics[srcDataCenterId];
            DrReceiverCacheMetricsAdapter metrics = metricsMap.get(cacheName = CU.mask(cacheName));
            if (metrics == null && create) {
                metrics = metricsMap.computeIfAbsent(cacheName, cName -> new DrReceiverCacheMetricsAdapter(this.ctx, srcDataCenterId, (String)cName));
            }
            return metrics;
        }
        return null;
    }

    @Nullable
    private DrReceiverOutMetricsAdapter receiverHubOutMetrics0(String cacheName, boolean create) {
        return this.getOrCreateCacheMetric(this.rcvHubOutMetrics, cacheName, create, DrReceiverOutMetricsAdapter::new);
    }

    @Nullable
    private DrSenderInMetricsAdapter senderHubInMetrics0(String cacheName, boolean create) {
        return this.getOrCreateCacheMetric(this.sndHubInMetrics, cacheName, create, DrSenderInMetricsAdapter::new);
    }

    @Nullable
    private DrSenderOutCacheMetricsAdapter senderHubOutMetrics0(byte destDataCenterId, String cacheName, boolean create) {
        if (this.sndHubOutMetrics != null) {
            ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter> metricsMap = this.sndHubOutMetrics[destDataCenterId];
            return this.getOrCreateDcMetric(metricsMap, destDataCenterId, cacheName, create, DrSenderOutCacheMetricsAdapter::new);
        }
        return null;
    }

    public void onSenderHubBatchReceived(String cacheName, int entryCnt, int byteCnt) {
        assert (this.sndHubInMetrics != null);
        DrSenderInMetricsAdapter cacheMetrics = this.senderHubInMetrics0(cacheName, true);
        if (cacheMetrics != null) {
            cacheMetrics.onBatchReceived(entryCnt, byteCnt);
        }
    }

    public void onSenderHubEntryFiltered(String cacheName, long entryCnt, long byteCnt) {
        assert (this.sndHubInMetrics != null);
        DrSenderInMetricsAdapter cacheMetrics = this.senderHubInMetrics0(cacheName, true);
        if (cacheMetrics != null) {
            cacheMetrics.onEntriesFiltered(entryCnt, byteCnt);
        }
    }

    public void onSenderHubBatchRejected(String cacheName) {
        assert (this.sndHubInMetrics != null);
        DrSenderInMetricsAdapter cacheMetrics = this.senderHubInMetrics0(cacheName, true);
        if (cacheMetrics != null) {
            cacheMetrics.onBatchRejected();
        }
    }

    public void onSenderHubBatchSent(byte destDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.sndHubOutMetrics != null);
        DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, true);
        if (metrics != null) {
            metrics.onBatchSent(entryCnt, byteCnt);
        }
    }

    public void onSenderHubBatchAcked(byte destDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt, long dur) {
        assert (this.sndHubOutMetrics != null);
        DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, true);
        if (metrics != null) {
            metrics.onBatchAcked(entryCnt, byteCnt, dur);
        }
    }

    public void onSenderHubBatchFailed(byte destDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.sndHubOutMetrics != null);
        DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, true);
        if (metrics != null) {
            metrics.onBatchFailed(entryCnt, byteCnt);
        }
    }

    public void onReceiverHubBatchReceived(byte srcDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.rcvHubCacheMetrics != null);
        DrReceiverCacheMetricsAdapter metrics = this.receiverHubCacheMetrics0(srcDataCenterId, cacheName, true);
        if (metrics != null) {
            metrics.onBatchReceived(entryCnt, byteCnt);
        }
    }

    public void onReceiverHubBatchSent(Byte dataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        DrReceiverCacheMetricsAdapter dcMetrics;
        assert (this.rcvHubOutMetrics != null);
        DrReceiverOutMetricsAdapter metrics = this.receiverHubOutMetrics0(cacheName, true);
        if (metrics != null) {
            metrics.onBatchSent(entryCnt, byteCnt);
        }
        if ((dcMetrics = this.receiverHubCacheMetrics0(dataCenterId, cacheName, false)) != null) {
            dcMetrics.onBatchSent(entryCnt, byteCnt);
        }
    }

    public void onReceiverHubBatchAcked(Byte dataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt, LongSupplier dur) {
        DrReceiverCacheMetricsAdapter dcMetrics;
        assert (this.rcvHubOutMetrics != null);
        DrReceiverOutMetricsAdapter metrics = this.receiverHubOutMetrics0(cacheName, true);
        if (metrics != null) {
            metrics.onBatchAcked(entryCnt, byteCnt, dur.getAsLong());
        }
        if ((dcMetrics = this.receiverHubCacheMetrics0(dataCenterId, cacheName, false)) != null) {
            dcMetrics.onBatchAcked(entryCnt, byteCnt, dur.getAsLong());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends DrAbstractMetricsAdapter> T getOrCreateCacheMetric(Map<String, T> metricsMap, String cacheName, boolean create, MetricFactory<T> metricFactory) {
        if (metricsMap != null) {
            DrAbstractMetricsAdapter metrics = (DrAbstractMetricsAdapter)metricsMap.get(cacheName = CU.mask(cacheName));
            if (metrics == null && create) {
                if (this.stopped || !this.isCacheConfigured(cacheName)) {
                    return null;
                }
                Object object = this.mux;
                synchronized (object) {
                    if (this.stopped || !this.isCacheConfigured(cacheName)) {
                        return null;
                    }
                    metrics = metricsMap.computeIfAbsent(cacheName, cName -> (DrAbstractMetricsAdapter)metricFactory.create(this.ctx, (String)cName));
                }
            }
            return (T)metrics;
        }
        return null;
    }

    private boolean isCacheConfigured(String cacheName) {
        return this.ctx.cache().cacheDescriptor(cacheName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends DrAbstractMetricsAdapter> T getOrCreateDcMetric(Map<String, T> metricsMap, byte dc, String cacheName, boolean create, DcMetricFactory<T> metricFactory) {
        if (metricsMap != null) {
            DrAbstractMetricsAdapter metrics = (DrAbstractMetricsAdapter)metricsMap.get(cacheName = CU.mask(cacheName));
            if (metrics == null && create) {
                if (this.stopped || !this.isCacheConfigured(cacheName)) {
                    return null;
                }
                Object object = this.mux;
                synchronized (object) {
                    if (this.stopped || !this.isCacheConfigured(cacheName)) {
                        return null;
                    }
                    metrics = metricsMap.computeIfAbsent(cacheName, cName -> (DrAbstractMetricsAdapter)metricFactory.create(this.ctx, dc, (String)cName));
                }
            }
            return (T)metrics;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mux;
        synchronized (object) {
            if (this.rcvHubCacheMetrics != null) {
                Arrays.stream(this.rcvHubCacheMetrics).filter(Objects::nonNull).forEach(map -> map.values().forEach(DrAbstractMetricsAdapter::reset));
            }
            if (this.rcvHubOutMetrics != null) {
                this.rcvHubOutMetrics.values().forEach(DrAbstractMetricsAdapter::reset);
            }
            if (this.sndHubOutMetrics != null) {
                Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).forEach(map -> map.values().forEach(DrAbstractMetricsAdapter::reset));
            }
            if (this.sndHubInMetrics != null) {
                this.sndHubInMetrics.values().forEach(DrAbstractMetricsAdapter::reset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCacheDestroy(String cacheName) {
        Object object = this.mux;
        synchronized (object) {
            Object metric;
            if (!F.isEmpty(this.sndHubOutMetrics)) {
                for (ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter> concurrentHashMap : this.sndHubOutMetrics) {
                    DrSenderOutCacheMetricsAdapter metric2;
                    if (concurrentHashMap == null || (metric2 = concurrentHashMap.remove(cacheName)) == null) continue;
                    metric2.unregister();
                }
            }
            if (!F.isEmpty(this.sndHubInMetrics) && (metric = this.sndHubInMetrics.remove(cacheName)) != null) {
                ((DrAbstractMetricsAdapter)metric).unregister();
            }
            if (!F.isEmpty(this.rcvHubCacheMetrics)) {
                metric = this.rcvHubCacheMetrics;
                int n = ((ConcurrentHashMap<String, DrReceiverCacheMetricsAdapter>[])metric).length;
                for (int i = 0; i < n; ++i) {
                    DrReceiverCacheMetricsAdapter metric2;
                    ConcurrentHashMap<String, DrReceiverCacheMetricsAdapter> concurrentHashMap = metric[i];
                    if (concurrentHashMap == null || (metric2 = concurrentHashMap.remove(cacheName)) == null) continue;
                    metric2.unregister();
                }
            }
            if (!F.isEmpty(this.rcvHubOutMetrics) && (metric = this.rcvHubOutMetrics.remove(cacheName)) != null) {
                ((DrAbstractMetricsAdapter)metric).unregister();
            }
        }
    }

    @Deprecated
    private long storeSizeBytes(Byte dcId) {
        if (this.sndOutGlobalStoreMetrics != null) {
            return this.sndOutGlobalStoreMetrics.storeSize();
        }
        if (this.sndOutDcStoreMetrics != null) {
            if (dcId == null) {
                return this.sndOutDcStoreMetrics.values().stream().mapToLong(DrSenderStoreMetricsAdapter::storeSize).sum();
            }
            assert (Objects.nonNull(this.sndOutDcStoreMetrics.get(dcId)));
            return this.sndOutDcStoreMetrics.get(dcId).storeSize();
        }
        return 0L;
    }

    private long stateTransferBufferSizeBytes() {
        return this.sndGlobalFstBufferMetrics == null ? 0L : this.sndGlobalFstBufferMetrics.storeSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.mux;
        synchronized (object) {
            this.stopped = true;
            if (!F.isEmpty(this.sndHubOutMetrics)) {
                for (ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter> concurrentHashMap : this.sndHubOutMetrics) {
                    if (concurrentHashMap == null) continue;
                    for (DrAbstractMetricsAdapter adapter : concurrentHashMap.values()) {
                        adapter.unregister();
                    }
                    concurrentHashMap.clear();
                }
            }
            if (!F.isEmpty(this.sndHubInMetrics)) {
                for (DrSenderInMetricsAdapter adapter : this.sndHubInMetrics.values()) {
                    adapter.unregister();
                }
                this.sndHubInMetrics.clear();
            }
            if (!F.isEmpty(this.rcvHubCacheMetrics)) {
                for (ConcurrentHashMap<String, DrReceiverCacheMetricsAdapter> concurrentHashMap : this.rcvHubCacheMetrics) {
                    if (concurrentHashMap == null) continue;
                    for (DrAbstractMetricsAdapter adapter : concurrentHashMap.values()) {
                        adapter.unregister();
                    }
                    concurrentHashMap.clear();
                }
            }
            if (!F.isEmpty(this.rcvHubOutMetrics)) {
                for (DrReceiverOutMetricsAdapter adapter : this.rcvHubOutMetrics.values()) {
                    adapter.unregister();
                }
                this.rcvHubOutMetrics.clear();
            }
            if (this.sndOutGlobalStoreMetrics != null) {
                this.sndOutGlobalStoreMetrics.unregister();
                this.sndOutGlobalStoreMetrics = null;
            }
            if (this.sndGlobalFstBufferMetrics != null) {
                this.sndGlobalFstBufferMetrics.unregister();
                this.sndGlobalFstBufferMetrics = null;
            }
            if (!F.isEmpty(this.sndOutDcStoreMetrics)) {
                for (DrSenderStoreMetricsAdapter adapter : this.sndOutDcStoreMetrics.values()) {
                    adapter.unregister();
                }
                this.sndOutDcStoreMetrics.clear();
            }
            if (this.rcvInMetrics != null) {
                this.rcvInMetrics.unregister();
                this.rcvInMetrics = null;
            }
        }
    }

    @FunctionalInterface
    static interface DcMetricFactory<T> {
        public T create(GridKernalContext var1, byte var2, String var3);
    }

    @FunctionalInterface
    static interface MetricFactory<T> {
        public T create(GridKernalContext var1, String var2);
    }
}

