/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.store.local;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheFileLocalStoreMap
implements AutoCloseable {
    private static final long ENTRY_SIZE = 10L;
    private static final int VAL_SHIFT = 16;
    public static final long VAL_MASK = 0xFFFFFFFFFFFFL;
    private static final int SCAN = 3;
    private long data;
    private int size;
    private int cap;
    private CacheFileLocalStoreMap next;

    public CacheFileLocalStoreMap(int cap) {
        this.reset(cap);
    }

    void reset(int cap) {
        assert (U.isPow2(cap)) : cap;
        long bytesSize = (long)cap * 10L;
        this.data = GridUnsafe.allocateMemory(bytesSize);
        GridUnsafe.zeroMemory(this.data, bytesSize);
        this.cap = cap;
    }

    void rehash() {
        assert (this.data != 0L);
        long oldData = this.data;
        int oldCap = this.cap;
        int oldMask = oldCap - 1;
        int cap = this.cap << 1;
        long offDelta = (long)oldCap * 10L;
        this.reset(cap);
        int mask = cap - 1;
        int s2 = this.size;
        for (int i = 0; i < oldCap; ++i) {
            boolean moved;
            long off = CacheFileLocalStoreMap.offset(i, 0, oldCap);
            int key = CacheFileLocalStoreMap.key(oldData, off);
            if (key == 0) continue;
            long v = CacheFileLocalStoreMap.value(oldData, off);
            assert (CacheFileLocalStoreMap.key(this.data, off + offDelta) == 0);
            int oldPos = key & oldMask;
            long newOff = off;
            if ((key & mask) != oldPos ^ oldPos > i) {
                newOff += offDelta;
            }
            this.set(newOff, key, v);
            if (this.next != null && (moved = newOff != off ? this.next.moveCollision(this, off, i) : this.next.moveCollision(this, off + offDelta, i + oldCap))) {
                ++this.size;
                if (this.next.size == 0) {
                    this.next = this.next.next;
                }
            }
            if (--s2 == 0) break;
        }
        GridUnsafe.freeMemory(oldData);
    }

    static long offset(int key, int scan, int cap) {
        return ((long)(key + scan) & (long)cap - 1L) * 10L;
    }

    static int key(long data, long off) {
        assert (data != 0L);
        return GridUnsafe.getInt(data + off);
    }

    static void key(long data, long off, int key) {
        assert (data != 0L);
        GridUnsafe.putInt(data + off, key);
    }

    static long value(long data, long off) {
        assert (data != 0L);
        long v = GridUnsafe.getLong(data + off + 2L);
        return GridUnsafe.BIG_ENDIAN ? v & 0xFFFFFFFFFFFFL : v >>> 16;
    }

    static void value(long data, long off, long v) {
        assert (data != 0L);
        assert ((v & 0xFFFFFFFFFFFFL) == v);
        if (!GridUnsafe.BIG_ENDIAN) {
            v <<= 16;
        }
        GridUnsafe.putLong(data + off + 2L, v);
    }

    public void add(int key, long val) {
        assert (key != 0);
        if (this.doAdd(key, val) != -1L) {
            ++this.size;
            if (this.cap - this.size < this.cap >>> 2) {
                this.rehash();
            }
        } else {
            if (this.next == null) {
                this.next = new CacheFileLocalStoreMap(32);
            }
            this.next.add(key, val);
        }
    }

    private long doAdd(int key, long val) {
        for (int i = 0; i < 3; ++i) {
            long off = CacheFileLocalStoreMap.offset(key, i, this.cap);
            if (CacheFileLocalStoreMap.key(this.data, off) != 0) continue;
            this.set(off, key, val);
            return off;
        }
        return -1L;
    }

    public boolean replace(int key, long oldVal, long newVal) {
        assert (key != 0);
        for (int i = 0; i < 3; ++i) {
            long off = CacheFileLocalStoreMap.offset(key, i, this.cap);
            if (CacheFileLocalStoreMap.key(this.data, off) != key || CacheFileLocalStoreMap.value(this.data, off) != oldVal) continue;
            this.set(off, key, newVal);
            return true;
        }
        return this.next != null && this.next.replace(key, oldVal, newVal);
    }

    public boolean remove(int key, long val) {
        assert (key != 0);
        for (int i = 0; i < 3; ++i) {
            long off = CacheFileLocalStoreMap.offset(key, i, this.cap);
            if (CacheFileLocalStoreMap.key(this.data, off) != key || CacheFileLocalStoreMap.value(this.data, off) != val) continue;
            this.doRemove(off, (key & this.cap - 1) + i);
            return true;
        }
        if (this.next != null && this.next.remove(key, val)) {
            if (this.next.size == 0) {
                this.next = this.next.next;
            }
            return true;
        }
        return false;
    }

    void set(long off, int key, long val) {
        CacheFileLocalStoreMap.set(this.data, off, key, val);
    }

    static void set(long data, long off, int key, long val) {
        CacheFileLocalStoreMap.value(data, off, val);
        CacheFileLocalStoreMap.key(data, off, key);
    }

    private void doRemove(long off, int pos) {
        if (this.next != null && this.next.moveCollision(this, off, pos)) {
            if (this.next.size == 0) {
                this.next = this.next.next;
            }
            return;
        }
        CacheFileLocalStoreMap.key(this.data, off, 0);
        --this.size;
    }

    private boolean moveCollision(CacheFileLocalStoreMap to, long toOff, int pos) {
        if (this.next != null && this.next.moveCollision(to, toOff, pos)) {
            if (this.next.size == 0) {
                this.next = this.next.next;
            }
            return true;
        }
        int maskTo = to.cap - 1;
        int pos0 = pos & this.cap - 1;
        for (int i = -2; i < 3; ++i) {
            int maskedKey;
            int gap;
            long off = CacheFileLocalStoreMap.offset(pos0, i, this.cap);
            int key = CacheFileLocalStoreMap.key(this.data, off);
            if (key == 0 || (gap = pos - (maskedKey = key & maskTo)) < 0 || gap >= 3) continue;
            to.set(toOff, key, CacheFileLocalStoreMap.value(this.data, off));
            this.doRemove(off, pos0 + i);
            return true;
        }
        return false;
    }

    public GridLongList get(int key, @Nullable GridLongList res) {
        assert (key != 0);
        for (int i = 0; i < 3; ++i) {
            long off = CacheFileLocalStoreMap.offset(key, i, this.cap);
            if (CacheFileLocalStoreMap.key(this.data, off) != key) continue;
            if (res == null) {
                res = new GridLongList(2);
            }
            res.add(CacheFileLocalStoreMap.value(this.data, off));
        }
        if (this.next != null) {
            return this.next.get(key, res);
        }
        return res;
    }

    public boolean contains(int key, long val) {
        assert (key != 0);
        for (int i = 0; i < 3; ++i) {
            long off = CacheFileLocalStoreMap.offset(key, i, this.cap);
            if (CacheFileLocalStoreMap.key(this.data, off) != key || CacheFileLocalStoreMap.value(this.data, off) != val) continue;
            return true;
        }
        return this.next != null && this.next.contains(key, val);
    }

    public int size(boolean withChildren) {
        int res = 0;
        CacheFileLocalStoreMap t2 = this;
        do {
            res += t2.size;
            t2 = t2.next;
        } while (withChildren && t2 != null);
        return res;
    }

    public void iterate(Closure c) throws IgniteCheckedException {
        for (int i = 0; i < this.cap; ++i) {
            long off = CacheFileLocalStoreMap.offset(i, 0, this.cap);
            int key = CacheFileLocalStoreMap.key(this.data, off);
            if (key == 0) continue;
            long val = CacheFileLocalStoreMap.value(this.data, off);
            c.apply(val);
        }
        if (this.next != null) {
            this.next.iterate(c);
        }
    }

    @Override
    public void close() {
        if (this.next != null) {
            this.next.close();
        }
        if (this.data != 0L) {
            GridUnsafe.freeMemory(this.data);
            this.data = 0L;
        }
    }

    public static interface Closure {
        public void apply(long var1) throws IgniteCheckedException;
    }
}

