/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gridgain.grid.internal.processors.cache.dr.ist.messages.DrStateRecord;

public class DrStateIO {
    private static final int ENTRY_SIZE = 12;
    public static final int VERSION = 1;

    public int version() {
        return 1;
    }

    public int size(Collection<DrStateRecord> states) {
        return 4 + states.size() * 12;
    }

    public void write(ByteBuffer buf, Collection<DrStateRecord> states) {
        buf.putInt(states.size());
        for (DrStateRecord s2 : states) {
            buf.putInt(s2.part());
            buf.putLong(s2.lwm());
        }
    }

    public List<DrStateRecord> read(ByteBuffer buf) {
        int size = buf.getInt();
        assert (buf.remaining() == size * 12) : buf.remaining();
        ArrayList<DrStateRecord> partStates = new ArrayList<DrStateRecord>();
        for (int i = 0; i < size; ++i) {
            int part = buf.getInt();
            long lwm = buf.getLong();
            DrStateRecord state = new DrStateRecord(part, lwm);
            partStates.add(state);
        }
        return partStates;
    }
}

