/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatch;
import org.jetbrains.annotations.Nullable;

class DrBatchManager {
    private final AtomicReference<DrBatch> curBatch = new AtomicReference();
    private final int batchSendSize;
    private final int batchSendSizeBytes;
    private final long batchSendPeriod;

    DrBatchManager(int batchSendSize, int batchSendSizeBytes, long batchSendPeriod) {
        assert (batchSendSize > 0 || batchSendSizeBytes > 0 || batchSendPeriod > 0L);
        this.batchSendSize = batchSendSize > 0 ? batchSendSize : Integer.MAX_VALUE;
        this.batchSendSizeBytes = batchSendSizeBytes > 0 ? batchSendSizeBytes : Integer.MAX_VALUE;
        this.batchSendPeriod = batchSendPeriod;
    }

    @Nullable
    DrBatch tryGetCurrentBatch() {
        return this.curBatch.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DrBatch getCurrentBatch() {
        DrBatch batch = this.curBatch.get();
        if (batch == null) {
            DrBatchManager drBatchManager = this;
            synchronized (drBatchManager) {
                batch = this.curBatch.get();
                if (batch == null) {
                    batch = new DrBatch(this.batchSendSize, this.batchSendSizeBytes, this.batchSendPeriod == 0L ? Long.MAX_VALUE : U.currentTimeMillis() + this.batchSendPeriod);
                    DrBatch oldBatch = this.curBatch.getAndSet(batch);
                    assert (oldBatch == null);
                }
            }
        }
        return batch;
    }

    void discardBatch(DrBatch batch) {
        this.curBatch.compareAndSet(batch, null);
    }
}

