/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.dr.EntryBuffer;
import org.gridgain.grid.internal.processors.cache.dr.SerializedDrEntry;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatchStateListener;

class DrBatch
implements DrBatchStateListener {
    private static final AtomicIntegerFieldUpdater<DrBatch> PERMIT_BYTES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DrBatch.class, "permitsBytes");
    private final int batchSendSize;
    private final long maxSendDelayTime;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int permitsBytes;
    private volatile Collection<SerializedDrEntry> entries = new ConcurrentLinkedQueue<SerializedDrEntry>();
    private boolean noAdd;
    private final CompletableFuture<Void> rejectFuture;
    private final CompletableFuture<Void> sendFuture;
    private final CompletableFuture<Void> ackFuture;

    DrBatch(int batchSendSize, int batchSendSizeBytes, long maxSendDelayTime) {
        this.batchSendSize = batchSendSize;
        this.permitsBytes = batchSendSizeBytes;
        this.maxSendDelayTime = maxSendDelayTime;
        this.rejectFuture = new CompletableFuture();
        this.sendFuture = this.rejectFuture.thenAccept(unused -> {});
        this.ackFuture = this.rejectFuture.thenAccept(unused -> {});
    }

    boolean add(SerializedDrEntry entry) {
        this.lock.readLock().lock();
        try {
            if (this.noAdd) {
                boolean bl = false;
                return bl;
            }
            if (PERMIT_BYTES_UPDATER.getAndAccumulate(this, entry.size(), (prev, x) -> Math.max(0, prev - x)) <= 0) {
                boolean bl = false;
                return bl;
            }
            this.entries.add(entry);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean denyAdditions() {
        this.lock.writeLock().lock();
        try {
            if (this.noAdd) {
                boolean bl = false;
                return bl;
            }
            this.noAdd = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean readyToSend() {
        Collection<SerializedDrEntry> entries0 = this.entries;
        return entries0 == null || this.permitsBytes <= 0 || entries0.size() >= this.batchSendSize || !entries0.isEmpty() && U.currentTimeMillis() >= this.maxSendDelayTime;
    }

    Map<Byte, EntryBuffer> toBuffers(GridCacheContext<?, ?> cctx) {
        HashMap<Byte, EntryBuffer> map = new HashMap<Byte, EntryBuffer>();
        byte curDC = -1;
        EntryBuffer buffer = null;
        for (SerializedDrEntry e : this.entries) {
            byte dcId = e.dcID();
            if (dcId != curDC) {
                buffer = map.computeIfAbsent(dcId, k -> new EntryBuffer(cctx));
            }
            assert (buffer != null);
            buffer.writeEntry(e);
        }
        this.entries = null;
        return map;
    }

    void listen(DrBatchStateListener lsnr) {
        this.sendFuture.thenRun(lsnr::onSent);
        this.ackFuture.thenRun(lsnr::onAcked);
        this.rejectFuture.exceptionally(e -> {
            lsnr.onRejected((Throwable)e);
            return null;
        });
    }

    @Override
    public void onAcked() {
        this.ackFuture.complete(null);
    }

    @Override
    public void onSent() {
        this.sendFuture.complete(null);
    }

    @Override
    public void onRejected(Throwable th) {
        if (th == null) {
            this.rejectFuture.cancel(false);
        } else {
            this.rejectFuture.completeExceptionally(th);
        }
    }

    public String toString() {
        return S.toString(DrBatch.class, this);
    }
}

