/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrEntryFilter;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrMetrics;
import org.gridgain.grid.internal.processors.cache.dr.Cancellable;
import org.gridgain.grid.internal.processors.cache.dr.EntryBuffer;
import org.gridgain.grid.internal.processors.cache.dr.ist.CachePartitionStateManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheSenderHubManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatchStateListener;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrEntryFilterWrapper;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrSearchKey;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrStateAware;
import org.gridgain.grid.internal.processors.cache.dr.ist.FstCacheRowFilter;
import org.gridgain.grid.internal.processors.cache.dr.ist.StateTransferInfo;
import org.gridgain.grid.internal.processors.cache.dr.ist.Watermark;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.DistributedStateTransferManager;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.fst.Batch;
import org.gridgain.grid.internal.processors.dr.fst.StateTransferJob;
import org.gridgain.grid.internal.processors.dr.fst.StateTransferTask;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.jetbrains.annotations.Nullable;

public class CacheStateTransferHandler
implements DistributedStateTransferManager.StateTransferListener,
DrStateAware {
    private final GridCacheContext cctx;
    private final GridBusyLock busyLock = new GridBusyLock();
    private final Consumer<StateTransferTask<? extends Batch>> executor;
    private final CachePartitionStateManager partStateMgr;
    private final DistributedStateTransferManager distrStateMgr;
    private final CacheSenderHubManager sndHubMgr;
    private final Supplier<CacheDrMetrics> metrics;
    private final IgniteLogger log;
    private final DrEntryFilterWrapper drFilter;
    private final ConcurrentMap<IgniteUuid, CacheStateTransferTask> tasksMap = new ConcurrentHashMap<IgniteUuid, CacheStateTransferTask>();
    private final int batchSendSizeBytes;
    private final AtomicReference<State> hdlState = new AtomicReference<State>(State.PAUSED);

    public CacheStateTransferHandler(GridCacheContext cctx, CachePartitionStateManager partStateMgr, CacheSenderHubManager sndHubMgr, DistributedStateTransferManager distrStateMgr, int batchSendSizeBytes, @Nullable CacheDrEntryFilter entryFilter, Consumer<StateTransferTask<? extends Batch>> taskExec, Supplier<CacheDrMetrics> metricsSup) {
        this.cctx = cctx;
        this.log = cctx.logger(CacheStateTransferHandler.class);
        this.partStateMgr = partStateMgr;
        this.sndHubMgr = sndHubMgr;
        this.distrStateMgr = distrStateMgr;
        this.executor = taskExec;
        this.metrics = metricsSup;
        distrStateMgr.listen(this);
        this.batchSendSizeBytes = batchSendSizeBytes;
        this.drFilter = entryFilter == null ? null : new DrEntryFilterWrapper(cctx.cacheObjectContext(), entryFilter);
        String cacheName = cctx.name();
        assert (CacheType.cacheType(cacheName) == CacheType.USER) : "replication of inner system caches is deprecated, cacheName=" + cacheName;
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stop DR state transfer handler.");
        }
        this.hdlState.set(State.CANCELLED);
        this.busyLock.block();
        this.tasksMap.values().forEach(CacheStateTransferTask::cancel);
        this.tasksMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStateTransferInfoChanged(StateTransferInfo oldInfo, StateTransferInfo newInfo) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (oldInfo == null) {
                this.startStateTransfer(newInfo);
            } else if (newInfo == null) {
                this.stopStateTransfer(oldInfo);
            } else {
                assert (oldInfo.fstId().equals(newInfo.fstId()));
                CacheStateTransferTask task = (CacheStateTransferTask)this.tasksMap.get(newInfo.fstId());
                if (task != null) {
                    task.onStateTransferInfoChanged(newInfo);
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startStateTransfer(StateTransferInfo fstInfo) {
        Map<Integer, Long> partStartCntr;
        boolean incremental;
        Set<Integer> primaryParts;
        block8: {
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting state transfer task: locNode=" + this.cctx.localNodeId() + ", info=" + fstInfo);
            }
            AffinityTopologyVersion topVer = this.cctx.affinity().affinityTopologyVersion();
            primaryParts = this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer);
            boolean bl = incremental = fstInfo.snapshotId() != null;
            if (incremental) {
                CacheSnapshotMetadata metadata = this.getSnapshotMetadata(fstInfo.snapshotId());
                if (metadata != null && metadata.partitionCounters() != null) {
                    partStartCntr = metadata.partitionCounters();
                    break block8;
                } else {
                    IllegalStateException ex = new IllegalStateException("Snapshot metadata not found: snapshotId=" + fstInfo.snapshotId());
                    try {
                        this.distrStateMgr.stopStateTransfer(fstInfo.fstKey(), ex.getMessage());
                        throw ex;
                    }
                    catch (IgniteCheckedException e) {
                        if (this.cctx.kernalContext().isStopping()) {
                            if (!this.log.isDebugEnabled()) throw ex;
                        }
                        this.log.error("Failed to change distributed state for incremental state transfer:  fstId=" + fstInfo.fstId(), e);
                    }
                    throw ex;
                }
            }
            partStartCntr = Collections.emptyMap();
        }
        CacheStateTransferTask task = new CacheStateTransferTask(fstInfo, partStartCntr, incremental);
        CacheStateTransferTask oldTask = this.tasksMap.putIfAbsent(fstInfo.fstId(), task);
        assert (oldTask == null);
        task.onPrimaryPartitionsChanged(primaryParts);
        if (this.hdlState.get() != State.ACTIVE) return;
        task.resume();
    }

    @Nullable
    private CacheSnapshotMetadata getSnapshotMetadata(Long snapshotId) {
        Objects.requireNonNull(snapshotId);
        GridGain plugin = (GridGain)this.cctx.kernalContext().pluginProvider("GridGain").plugin();
        assert (plugin != null);
        GridSnapshot snapshot = plugin.snapshot();
        if (!(snapshot instanceof GridSnapshotEx)) {
            throw new UnsupportedOperationException("Snapshot feature or integration with DR is not supported.");
        }
        try {
            SnapshotMetadata snapshotMeta = ((GridSnapshotEx)snapshot).snapshotMetadata(snapshotId, null);
            if (snapshotMeta != null) {
                return snapshotMeta.cacheMetadata().get(this.cctx.groupId());
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to load snapshot metadata: snapshot=" + snapshotId);
        }
        return null;
    }

    private void stopStateTransfer(StateTransferInfo fstInfo) {
        CacheStateTransferTask task = (CacheStateTransferTask)this.tasksMap.remove(fstInfo.fstId());
        if (task != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Stopping state transfer task: info=" + fstInfo);
            }
            this.partStateMgr.cleanFstWM();
            if (!task.pendingParts.isEmpty()) {
                task.cancel();
            }
        }
    }

    public void onPartitionAssignment(Set<Integer> primaryParts) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.tasksMap.values().forEach(task -> task.onPrimaryPartitionsChanged(primaryParts));
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void onResume() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (this.hdlState.compareAndSet(State.PAUSED, State.ACTIVE)) {
                this.tasksMap.values().forEach(CacheStateTransferTask::resume);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void onPause() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (this.hdlState.compareAndSet(State.ACTIVE, State.PAUSED)) {
                this.tasksMap.values().forEach(CacheStateTransferTask::pause);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void submit(StateTransferTask<Batch> task) {
        this.executor.accept(task);
    }

    private static int counterToHash(long cntr) {
        return (int)(cntr >> 32);
    }

    private static long hashToCntr(long cntr, int hash) {
        long newCntr = (long)hash << 32;
        if ((cntr & 0xFFFFFFFF00000000L) == (newCntr & 0xFFFFFFFF00000000L)) {
            int seq = (int)(cntr & 0xFFFFFFFFL);
            assert (seq >= 0 && seq < 0x7FFFFFFE) : Long.toHexString(cntr);
            newCntr |= (long)(seq + 1) & 0xFFFFFFFFL;
        }
        assert (newCntr > cntr);
        return newCntr;
    }

    private class PartitionTransferJob
    implements StateTransferJob<Batch>,
    Cancellable {
        private final int part;
        private final CacheStateTransferTask execCtx;
        private volatile boolean canceled;
        private final Watermark hwm;

        PartitionTransferJob(int part, long startCntr, CacheStateTransferTask execCtx) {
            this.part = part;
            this.execCtx = execCtx;
            this.hwm = new Watermark(startCntr);
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        public int partition() {
            return this.part;
        }

        @Override
        public void runWithBatch(Batch batch) {
            block3: {
                try {
                    this.scanPartition(this.part, this.execCtx.rowFilter(this.part));
                }
                catch (Exception e) {
                    if (!this.isCancelled()) {
                        U.error(CacheStateTransferHandler.this.log, "Failed to run state transfer task.", e);
                    }
                    if (!CacheStateTransferHandler.this.log.isTraceEnabled()) break block3;
                    CacheStateTransferHandler.this.log.trace("State transfer task has been stopped for cache: name=" + CacheStateTransferHandler.this.cctx.name() + ", cause=" + e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void scanPartition(int part, FstCacheRowFilter rowFilter) throws IgniteCheckedException {
            if (!CacheStateTransferHandler.this.cctx.gate().enterIfNotStopped()) {
                return;
            }
            try {
                GridDhtLocalPartition locPart = CacheStateTransferHandler.this.cctx.topology().localPartition(part, AffinityTopologyVersion.NONE, false);
                if (locPart == null || !locPart.reserve()) {
                    if (!CacheStateTransferHandler.this.log.isDebugEnabled()) return;
                    CacheStateTransferHandler.this.log.debug("Failed to reserve partition for state transfer scan [part=" + part + ']');
                    return;
                }
                try {
                    if (locPart.state() != GridDhtPartitionState.OWNING || !CacheStateTransferHandler.this.cctx.affinity().primaryByPartition(CacheStateTransferHandler.this.cctx.localNode(), part, AffinityTopologyVersion.NONE)) {
                        if (!CacheStateTransferHandler.this.log.isDebugEnabled()) return;
                        CacheStateTransferHandler.this.log.debug("Skip state transfer for non-owned partition [part=" + part + ']');
                        return;
                    }
                    if (CacheStateTransferHandler.this.cctx.topology().stopping()) {
                        throw new CacheStoppedException(CacheStateTransferHandler.this.cctx.name());
                    }
                    long startCntr = this.hwm.get();
                    GridCursor<? extends CacheDataRow> cursor = CacheStateTransferHandler.this.cctx.offheap().dataStore(locPart).cursor(CacheStateTransferHandler.this.cctx.cacheId(), new DrSearchKey(CacheStateTransferHandler.counterToHash(startCntr)), null, null, null, 3);
                    long currCntr = startCntr;
                    BatchImpl batch = null;
                    while (!this.isCancelled() && cursor.next()) {
                        CacheDataRow row = cursor.get();
                        if (!rowFilter.apply(row)) continue;
                        if (batch == null) {
                            batch = new BatchImpl(currCntr, CacheStateTransferHandler.this.batchSendSizeBytes);
                        }
                        this.addRowToBatch(batch, row);
                        currCntr = CacheStateTransferHandler.hashToCntr(currCntr, row.key().hashCode());
                        if (!batch.readyToSend()) continue;
                        batch.endCntr(currCntr);
                        this.send(batch);
                        batch = null;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    if (batch != null && !batch.isEmpty()) {
                        batch.endCntr(currCntr);
                        this.send(batch);
                    }
                    this.hwm.update(currCntr, Long.MAX_VALUE);
                    CacheStateTransferHandler.this.partStateMgr.fstWM(part, currCntr, Long.MAX_VALUE);
                    if (CacheStateTransferHandler.this.partStateMgr.fstWM(part) != Long.MAX_VALUE) return;
                    this.execCtx.onJobFinished(this);
                    return;
                }
                finally {
                    locPart.release();
                }
            }
            finally {
                CacheStateTransferHandler.this.cctx.gate().leave();
            }
        }

        public void addRowToBatch(BatchImpl batch, CacheDataRow row) throws IgniteCheckedException {
            GridCacheRawVersionedEntry entry = new GridCacheRawVersionedEntry(row.key(), row.value().cacheObjectType() == -1 ? null : row.value(), row.expireTime() > 0L ? 1L : 0L, row.expireTime(), row.version().conflictVersion());
            if (CacheStateTransferHandler.this.drFilter != null && !CacheStateTransferHandler.this.drFilter.accept(entry)) {
                ((CacheDrMetrics)CacheStateTransferHandler.this.metrics.get()).onSenderCacheEntryFiltered();
                return;
            }
            batch.add(entry);
        }

        private void send(BatchImpl batch) {
            if (CacheStateTransferHandler.this.log.isTraceEnabled()) {
                CacheStateTransferHandler.this.log.trace("Sending batch: " + batch);
            }
            CacheStateTransferHandler.this.sndHubMgr.send(batch.buffers(), batch, this.execCtx.stateTransferId(), this.execCtx.targetDCs());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onBatchReject() {
            PartitionTransferJob partitionTransferJob = this;
            synchronized (partitionTransferJob) {
                if (this.canceled) {
                    return;
                }
                this.cancel();
                if (CacheStateTransferHandler.this.partStateMgr.fstWM(this.part) == Long.MAX_VALUE) {
                    return;
                }
            }
            this.execCtx.restartJob(this.part);
        }

        private void onBatchSent(long startCntr, long endCounter) {
            if (!this.canceled) {
                this.hwm.update(startCntr, endCounter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onBatchAck(long startCntr, long endCntr) {
            PartitionTransferJob partitionTransferJob = this;
            synchronized (partitionTransferJob) {
                if (this.canceled) {
                    return;
                }
                CacheStateTransferHandler.this.partStateMgr.fstWM(this.part, startCntr, endCntr);
                if (CacheStateTransferHandler.this.partStateMgr.fstWM(this.part) < Long.MAX_VALUE) {
                    return;
                }
            }
            this.execCtx.onJobFinished(this);
        }

        private class BatchImpl
        implements DrBatchStateListener,
        Batch {
            private Map<Byte, EntryBuffer> buffers = new HashMap<Byte, EntryBuffer>();
            private final long startCntr;
            private long endCntr;
            private final int batchSendSizeBytes;
            private int batchSize;

            BatchImpl(long startCntr, int batchSendSizeBytes) {
                this.batchSendSizeBytes = batchSendSizeBytes;
                this.startCntr = startCntr;
            }

            @Override
            public void onAcked() {
                PartitionTransferJob.this.onBatchAck(this.startCntr, this.endCntr);
            }

            @Override
            public void onRejected(Throwable err) {
                PartitionTransferJob.this.onBatchReject();
            }

            @Override
            public void onSent() {
                PartitionTransferJob.this.onBatchSent(this.startCntr, this.endCntr);
            }

            boolean readyToSend() {
                return this.batchSize > this.batchSendSizeBytes;
            }

            boolean isEmpty() {
                return this.buffers.isEmpty();
            }

            <K, V> void add(GridCacheRawVersionedEntry<K, V> entry) {
                EntryBuffer buffer = this.buffers.computeIfAbsent(entry.version().dataCenterId(), k -> new EntryBuffer(CacheStateTransferHandler.this.cctx));
                buffer.writeEntry(entry);
                this.batchSize += DrUtils.drEntrySize(entry);
            }

            Map<Byte, EntryBuffer> buffers() {
                Map<Byte, EntryBuffer> buffers0 = this.buffers;
                this.buffers = null;
                return buffers0;
            }

            public void endCntr(long endCntr) {
                this.endCntr = endCntr;
            }

            public String toString() {
                return "FstBatch[, batchSize=" + this.batchSize + ", part=" + PartitionTransferJob.this.part + ", startCntr=" + this.startCntr + ", endCntr=" + this.endCntr + ']';
            }
        }
    }

    private class CacheStateTransferTask
    implements StateTransferTask<Batch> {
        private final StateTransferInfo info;
        private final Queue<Integer> partQ = new LinkedList<Integer>();
        private final Map<Integer, PartitionTransferJob> jobs = new HashMap<Integer, PartitionTransferJob>();
        private final AtomicReference<State> state = new AtomicReference<State>(State.PAUSED);
        private final BitSet pendingParts;
        private final Map<Integer, Long> maxCntrs = new HashMap<Integer, Long>();
        private final Map<Integer, Long> minCntrs;
        private final boolean isIncremental;

        CacheStateTransferTask(StateTransferInfo info, Map<Integer, Long> startCntrs, boolean isIncremental) {
            this.info = info;
            this.pendingParts = info.pendingParts();
            this.minCntrs = Objects.requireNonNull(startCntrs);
            this.isIncremental = isIncremental;
        }

        @Override
        @Nullable
        public synchronized StateTransferJob<Batch> nextJob() {
            Integer part;
            if (this.state.get() != State.ACTIVE) {
                return null;
            }
            while ((part = this.partQ.poll()) != null) {
                if (!this.pendingParts.get(part)) continue;
                return this.jobs.computeIfAbsent(part, p -> new PartitionTransferJob((int)p, CacheStateTransferHandler.this.partStateMgr.fstWM((int)p), this));
            }
            return null;
        }

        synchronized void onPrimaryPartitionsChanged(Set<Integer> parts) {
            if (F.isEmpty(parts) || this.state.get() == State.CANCELLED) {
                return;
            }
            if (!this.jobs.isEmpty()) {
                Iterator<Map.Entry<Integer, PartitionTransferJob>> it = this.jobs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, PartitionTransferJob> job = it.next();
                    if (parts.contains(job.getKey())) continue;
                    job.getValue().cancel();
                    it.remove();
                }
            }
            this.partQ.clear();
            parts.forEach(k -> {
                if (this.pendingParts.get((int)k) && !this.jobs.containsKey(k)) {
                    this.maxCntrs.putIfAbsent((Integer)k, this.isIncremental ? CacheStateTransferHandler.this.partStateMgr.lwm((int)k) : CacheStateTransferHandler.this.partStateMgr.updateCounter((int)k));
                    this.partQ.offer((Integer)k);
                }
            });
            if (!this.partQ.isEmpty() && this.state.get() == State.ACTIVE) {
                CacheStateTransferHandler.this.submit(this);
            }
        }

        @Override
        public synchronized void cancel() {
            this.state.set(State.CANCELLED);
            this.jobs.values().forEach(PartitionTransferJob::cancel);
            this.jobs.clear();
        }

        @Override
        public boolean isCancelled() {
            return this.state.get() == State.CANCELLED;
        }

        public Collection<Byte> targetDCs() {
            return this.info.targetDCs();
        }

        public IgniteUuid stateTransferId() {
            return this.info.fstId();
        }

        public FstCacheRowFilter rowFilter(int part) {
            long minUpdCntr = this.minCntrs.getOrDefault(part, Long.MIN_VALUE);
            long maxUpdCntr = this.maxCntrs.getOrDefault(part, Long.MAX_VALUE);
            return new FstCacheRowFilter(minUpdCntr, maxUpdCntr, null);
        }

        public synchronized void restartJob(int part) {
            this.partQ.add(part);
            this.jobs.remove(part);
            if (this.state.get() == State.ACTIVE) {
                CacheStateTransferHandler.this.submit(this);
            }
        }

        public synchronized void onStateTransferInfoChanged(StateTransferInfo info) {
            this.pendingParts.and(info.pendingParts());
        }

        public synchronized void pause() {
            if (this.state.compareAndSet(State.ACTIVE, State.PAUSED)) {
                this.jobs.forEach((key, value) -> {
                    this.partQ.add((Integer)key);
                    value.cancel();
                });
                this.jobs.clear();
            }
        }

        public synchronized void resume() {
            if (this.state.compareAndSet(State.PAUSED, State.ACTIVE)) {
                CacheStateTransferHandler.this.submit(this);
            }
        }

        public synchronized void onJobFinished(PartitionTransferJob job) {
            if (this.jobs.remove(job.part, job)) {
                if (CacheStateTransferHandler.this.log.isDebugEnabled()) {
                    CacheStateTransferHandler.this.log.debug("DR state transfer done for partition: part=" + job.part + ", fst=" + this.info.fstId());
                }
                this.pendingParts.clear(job.part);
                CacheStateTransferHandler.this.distrStateMgr.markPartitionTransferred(this.info.fstKey(), job.part);
            }
        }
    }

    private static enum State {
        ACTIVE,
        PAUSED,
        CANCELLED;

    }
}

