/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.dr.SerializedDrEntry;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class EntryBuffer
implements AutoCloseable {
    private final GridCacheContext cctx;
    private final DataOutputStream dataOutput;
    private final GridByteArrayOutputStream byteStream;
    private int cnt;

    public EntryBuffer(GridCacheContext cctx) {
        this.cctx = cctx;
        this.byteStream = new GridByteArrayOutputStream(32768);
        this.dataOutput = new DataOutputStream(this.byteStream);
    }

    public void writeEntry(GridCacheRawVersionedEntry entry) {
        try {
            entry.marshal(this.cctx.cacheObjectContext(), this.cctx.marshaller());
            DrUtils.writeDrEntry(this.dataOutput, entry);
            ++this.cnt;
        }
        catch (IOException | IgniteCheckedException e) {
            U.closeQuiet(this.dataOutput);
            throw new IgniteException("Failed to marshal data for replication.", e);
        }
    }

    public void writeEntry(SerializedDrEntry entry) {
        try {
            this.dataOutput.write(entry.entryBytes());
            ++this.cnt;
        }
        catch (IOException e) {
            U.closeQuiet(this.dataOutput);
            throw new IgniteException("Failed to marshal data for replication.", e);
        }
    }

    public byte[] getBytes() {
        this.flush();
        return this.byteStream.toByteArray();
    }

    public int entriesCnt() {
        return this.cnt;
    }

    public int sizeBytes() {
        return this.byteStream.size();
    }

    public void flush() {
        try {
            this.dataOutput.flush();
        }
        catch (IOException e) {
            throw new IgniteException("Failed to marshal data for replication.", e);
        }
        finally {
            U.closeQuiet(this.dataOutput);
        }
    }

    @Override
    public void close() throws Exception {
        this.dataOutput.close();
    }
}

