/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class CacheDrStateTransferKey
implements Externalizable,
GridCacheInternal {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private IgniteUuid id;
    private List<Byte> dataCenterIds;

    public CacheDrStateTransferKey() {
    }

    public CacheDrStateTransferKey(String cacheName, IgniteUuid id, Collection<Byte> dataCenterIds) {
        this.cacheName = cacheName;
        this.id = id;
        this.dataCenterIds = new ArrayList<Byte>(dataCenterIds);
        Collections.sort(this.dataCenterIds);
    }

    public String cacheName() {
        return this.cacheName;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public Collection<Byte> dataCenterIds() {
        return this.dataCenterIds;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        U.writeGridUuid(out, this.id);
        U.writeByteCollection(out, this.dataCenterIds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.id = U.readGridUuid(in);
        this.dataCenterIds = U.readByteList(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheDrStateTransferKey that = (CacheDrStateTransferKey)o;
        return F.eq(this.id, that.id);
    }

    public int hashCode() {
        int res = this.id.hashCode();
        res = 31 * res + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        return res;
    }

    public String toString() {
        return S.toString(CacheDrStateTransferKey.class, this);
    }
}

