/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class SnapshotRemotePath
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private File path;
    private URI uri;
    private String keyAlias;

    public SnapshotRemotePath() {
    }

    public SnapshotRemotePath(SnapshotPath snapshotPath) {
        this.path = snapshotPath.path();
        this.uri = snapshotPath.uri();
        this.keyAlias = snapshotPath.keyAlias();
    }

    public SnapshotRemotePath(File snapshotPath) {
        this.path = snapshotPath;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.path);
        out.writeObject(this.uri);
        U.writeString(out, this.keyAlias);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = (File)in.readObject();
        this.uri = (URI)in.readObject();
        this.keyAlias = U.readString(in);
    }

    public String toString() {
        return S.toString(SnapshotRemotePath.class, this);
    }

    public URI uri() {
        return this.uri;
    }

    public File path() {
        return this.path;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    @Nullable
    public static Collection<SnapshotRemotePath> convertToSnapshotPathCollection(@Nullable Collection<File> paths) {
        if (paths == null) {
            return null;
        }
        return paths.stream().map(SnapshotRemotePath::new).collect(Collectors.toList());
    }
}

