/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.file;

import com.sun.nio.file.ExtendedCopyOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;

public class FsSnapshotPath
implements SnapshotPath {
    private final File file;

    public FsSnapshotPath(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean exists() {
        return Files.exists(this.file.toPath(), new LinkOption[0]);
    }

    @Override
    public boolean delete() {
        return U.delete(this.file);
    }

    @Override
    public void deleteIfEmpty() throws IOException {
        Files.delete(this.file.toPath());
    }

    @Override
    public void createNewFile() throws IOException {
        this.file.createNewFile();
    }

    @Override
    public FsSnapshotPath getParent() {
        File parentFile = this.file.getParentFile();
        return parentFile != null ? new FsSnapshotPath(parentFile) : null;
    }

    @Override
    public boolean createDirectories() {
        return this.file.mkdirs();
    }

    @Override
    public FsSnapshotPath resolve(String name) {
        return new FsSnapshotPath(new File(this.file, name));
    }

    @Override
    public FsSnapshotPath resolveRegularOrCompressed(String name) {
        Path path = this.file.toPath();
        for (CompressionOption opt : CompressionOption.values()) {
            Path file = path.resolve(name + opt.fileExtension());
            if (!Files.exists(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0])) continue;
            return new FsSnapshotPath(file.toFile());
        }
        return null;
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    public String relativize(FsSnapshotPath file) {
        return this.file.toPath().relativize(file.file.toPath()).toString();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isEmptyDirectory() {
        return F.isEmptyDirectory(this.file.toPath());
    }

    public long fileCount() throws IOException {
        return U.fileCount(this.file.toPath());
    }

    @Override
    public FsSnapshotPath resolveSibling(String s2) {
        return new FsSnapshotPath(this.file.toPath().resolveSibling(s2).toFile());
    }

    @Override
    public OutputStream outputStream() throws FileNotFoundException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream inputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public Collection<SnapshotPath> getEntries() {
        File[] subfiles = this.file.listFiles();
        if (subfiles == null || subfiles.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(subfiles).map(FsSnapshotPath::new).collect(Collectors.toList());
    }

    @Override
    public void sync() {
        try (FileChannel ch = FileChannel.open(this.file.toPath(), StandardOpenOption.WRITE);){
            ch.force(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void copyFrom(Path srcFile) throws IOException {
        Path tmpFile = this.file.getParentFile().toPath().resolve(this.getName() + ".tmp");
        Files.copy(srcFile, tmpFile, StandardCopyOption.REPLACE_EXISTING, ExtendedCopyOption.INTERRUPTIBLE);
        Files.move(tmpFile, this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public String toString() {
        return this.file.toString();
    }
}

