/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.file;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.MissingReadOnlySnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPathWrapper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CachedSnapshotPath
extends SnapshotPathWrapper {
    @Nullable
    private final CachedSnapshotPath parent;
    private volatile boolean resolved;
    private Map<String, CachedSnapshotPath> entries;

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static SnapshotPath cachedPath(@Nullable SnapshotPath snapshotPath) {
        if (snapshotPath == null) {
            return null;
        }
        if (snapshotPath instanceof FsSnapshotPath || snapshotPath instanceof CachedSnapshotPath) {
            return snapshotPath;
        }
        return new CachedSnapshotPath(null, snapshotPath);
    }

    private CachedSnapshotPath(@Nullable CachedSnapshotPath parent, SnapshotPath path) {
        super(path);
        this.parent = parent;
    }

    @Override
    public SnapshotPath getParent() {
        return this.parent == null ? null : this.delegate.getParent();
    }

    @Override
    public SnapshotPath resolveSibling(String fileName) {
        if (this.parent == null) {
            return this.delegate.resolveSibling(fileName);
        }
        CachedSnapshotPath resolvedFile = this.parent.resolveCachedPath(fileName);
        return resolvedFile == null ? new MissingReadOnlySnapshotPath(this.parent, fileName) : resolvedFile;
    }

    @Override
    public SnapshotPath resolve(String name) {
        CachedSnapshotPath resolvedPath = this.resolveCachedPath(name);
        return resolvedPath == null ? new MissingReadOnlySnapshotPath(this, name) : resolvedPath;
    }

    @Override
    public SnapshotPath resolveRegularOrCompressed(String name) {
        for (CompressionOption opt : CompressionOption.values()) {
            CachedSnapshotPath cachedPath = this.resolveCachedPath(name + opt.fileExtension());
            if (cachedPath == null || !cachedPath.isFile()) continue;
            return cachedPath;
        }
        return null;
    }

    @Override
    public Collection<SnapshotPath> getEntries() {
        this.ensureResolved();
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Nullable
    private CachedSnapshotPath resolveCachedPath(String name) {
        this.ensureResolved();
        return this.entries.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureResolved() {
        if (!this.resolved) {
            CachedSnapshotPath cachedSnapshotPath = this;
            synchronized (cachedSnapshotPath) {
                if (!this.resolved) {
                    this.entries = this.delegate.getEntries().stream().collect(Collectors.toMap(SnapshotPath::getName, snapshotPath -> new CachedSnapshotPath(this, (SnapshotPath)snapshotPath)));
                    this.resolved = true;
                }
            }
        }
    }
}

