/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.jetbrains.annotations.Nullable;

public class SnapshotInfoExtended
implements SnapshotInfoEx {
    private static final long serialVersionUID = 0L;
    private final long snapshotId;
    private final boolean fullSnapshot;
    private final UUID initiatorNode;
    private final Map<String, Integer> cacheNames;
    private final String msg;
    @Nullable
    private final Map<Object, Map<String, String>> snapshotAttrs;
    private final Collection<ClusterNode> top;
    private final BaselineTopology baselineTopology;
    private final Map<Long, Set<String>> previousSnapshots;
    private final Map<String, CacheMode> cacheModes;
    private final long sizeWithoutIndexes;
    private final long size;
    private CompressionOption compressionOption;
    private int compressionLevel;
    private final long walSize;
    private final String masterKeyName;

    public SnapshotInfoExtended(long snapshotId, UUID initiatorNode, boolean fullSnapshot, Map<String, Integer> cacheNames, Map<String, CacheMode> cacheModes, Collection<ClusterNode> top, @Nullable BaselineTopology baselineTopology, Map<Long, Set<String>> previousSnapshots, @Nullable Map<Object, Map<String, String>> snapshotAttrs, String msg, long size, long sizeWithoutIndexes, CompressionOption compressionOption, int compressionLevel, long walSize, @Nullable String masterKeyName) {
        this.snapshotId = snapshotId;
        this.fullSnapshot = fullSnapshot;
        this.initiatorNode = initiatorNode;
        this.cacheNames = new HashMap<String, Integer>(cacheNames);
        this.cacheModes = cacheModes;
        this.msg = msg;
        this.snapshotAttrs = snapshotAttrs;
        this.top = top;
        this.baselineTopology = baselineTopology;
        this.previousSnapshots = previousSnapshots;
        this.size = size;
        this.sizeWithoutIndexes = sizeWithoutIndexes;
        this.compressionOption = compressionOption;
        this.compressionLevel = compressionLevel;
        this.walSize = walSize;
        this.masterKeyName = masterKeyName;
    }

    public SnapshotInfoExtended(SnapshotMetadata meta, Map<Object, Map<String, String>> attrs) {
        this(meta.id(), meta.initiatorNodeId(), meta.fullSnapshot(), meta.cacheNamesWithGroups(), meta.cacheModes(), meta.topology(), null, meta.previousSnapshots(), attrs, meta.message(), meta.sizeInBytes(), meta.sizeOnlyDataInBytes(), CompressionOption.NONE, -1, 0L, null);
    }

    public SnapshotInfoExtended(SnapshotMetadataV2 meta, Map<Object, Map<String, String>> attrs, long walSize) {
        this(meta.id(), meta.initiatorNodeId(), meta.fullSnapshot(), meta.cacheNamesWithGroups(), meta.cacheModes(), meta.topology(), meta.baselineTopology(), meta.previousSnapshots(), attrs, meta.message(), meta.sizeInBytes(), meta.sizeOnlyDataInBytes(), meta.compressionOption(), meta.compressionLevel(), walSize, meta.encryptionOptions() != null ? meta.encryptionOptions().getMasterKeyName() : null);
    }

    @Override
    public String masterKeyName() {
        return this.masterKeyName;
    }

    @Override
    public long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public boolean fullSnapshot() {
        return this.fullSnapshot;
    }

    @Override
    public UUID initiatorNode() {
        return this.initiatorNode;
    }

    @Override
    public Set<String> cacheNames() {
        return new HashSet<String>(this.cacheNames.keySet());
    }

    public Map<String, Integer> cacheNamesWithGroups() {
        return this.cacheNames;
    }

    @Override
    public String message() {
        return this.msg;
    }

    @Override
    public CompressionOption compressionOption() {
        return this.compressionOption;
    }

    @Override
    public int compressionLevel() {
        return this.compressionLevel;
    }

    @Override
    public Collection<ClusterNode> topology() {
        return this.top;
    }

    @Override
    @Nullable
    public BaselineTopology baselineTopology() {
        return this.baselineTopology;
    }

    @Override
    public Map<Long, Set<String>> previousSnapshots() {
        return this.previousSnapshots;
    }

    @Override
    public Map<String, CacheMode> cacheModes() {
        return this.cacheModes;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long walSize() {
        return this.walSize;
    }

    @Override
    public long sizeWithoutIndexes() {
        return this.sizeWithoutIndexes;
    }

    @Override
    @Nullable
    public Map<Object, Map<String, String>> snapshotAttributes() {
        return this.snapshotAttrs;
    }

    public String toString() {
        return "SnapshotInfoImpl{snapshotId=" + this.snapshotId + ", fullSnapshot=" + this.fullSnapshot + ", initiatorNode=" + this.initiatorNode + ", cacheNames=" + this.cacheNames + ", compressionOption=" + (Object)((Object)this.compressionOption) + ", compressionLevel=" + this.compressionLevel + '}';
    }
}

