/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ConsistentCutMeta
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long id;
    private WALPointer fuzzyBorderStartPtr;
    private WALPointer cutPtr;
    private long consistentCutPtrTime;
    @GridToStringExclude
    private Set<GridCacheVersion> skipTxs;

    public ConsistentCutMeta() {
    }

    public ConsistentCutMeta(long id, WALPointer fuzzyBorderStartPtr, WALPointer cutPtr, long consistentCutPtrTime, Set<GridCacheVersion> skipTxs) {
        this.id = id;
        this.fuzzyBorderStartPtr = fuzzyBorderStartPtr;
        this.cutPtr = cutPtr;
        this.consistentCutPtrTime = consistentCutPtrTime;
        this.skipTxs = skipTxs;
    }

    public long consistentCutId() {
        return this.id;
    }

    public WALPointer fuzzyBorderStartPtr() {
        return this.fuzzyBorderStartPtr;
    }

    public WALPointer cutPtr() {
        return this.cutPtr;
    }

    public long cutPtrTime() {
        return this.consistentCutPtrTime;
    }

    public Set<GridCacheVersion> skipTxs() {
        return this.skipTxs;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        this.writeWalPointer(this.fuzzyBorderStartPtr, out);
        this.writeWalPointer(this.cutPtr, out);
        out.writeLong(this.consistentCutPtrTime);
        U.writeCollection(out, this.skipTxs);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.fuzzyBorderStartPtr = this.readWalPointer(in);
        this.cutPtr = this.readWalPointer(in);
        this.consistentCutPtrTime = in.readLong();
        this.skipTxs = U.readSet(in);
    }

    private void writeWalPointer(WALPointer ptr, ObjectOutput out) throws IOException {
        FileWALPointer filePtr = (FileWALPointer)ptr;
        out.writeLong(filePtr.index());
        out.writeInt(filePtr.fileOffset());
        out.writeInt(filePtr.length());
    }

    private WALPointer readWalPointer(ObjectInput in) throws IOException {
        long idx = in.readLong();
        int fileOffset = in.readInt();
        int length = in.readInt();
        return new FileWALPointer(idx, fileOffset, length);
    }

    public String toString() {
        return S.toString(ConsistentCutMeta.class, this);
    }
}

