/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.conflict;

import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.version.CacheVersionConflictResolver;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.CachePluginContext;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.cache.conflict.CacheConflictResolver;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.internal.processors.cache.conflict.CacheConflictResolverWrapper;
import org.jetbrains.annotations.Nullable;

public class CacheEntConflictResolutionManager<K, V>
extends GridCacheManagerAdapter<K, V>
implements CacheConflictResolutionManager<K, V> {
    private final CachePluginContext<GridGainCacheConfiguration> ctx;
    private final boolean forceUseConflictRslvr = IgniteSystemProperties.getBoolean("GG_DR_FORCE_ENABLE_CONFLICT_RESOLVER", false);
    private boolean resolverEnabled;
    private CacheConflictResolver<K, V> conflictResolver;
    private CacheConflictMode conflictMode;

    public CacheEntConflictResolutionManager(@Nullable CachePluginContext<GridGainCacheConfiguration> ctx) {
        this.ctx = ctx;
    }

    @Override
    public CacheVersionConflictResolver conflictResolver() {
        if (this.cctx.store().isLocal() || !this.resolverEnabled && this.forceUseConflictRslvr) {
            return new CacheConflictResolverWrapper(GridGainCacheConfiguration.DFLT_CONFLICT_RSLVR_MODE, null);
        }
        if (!this.resolverEnabled) {
            return null;
        }
        return new CacheConflictResolverWrapper(this.conflictMode, this.conflictResolver);
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        if (this.ctx == null) {
            return;
        }
        GridGainCacheConfiguration ggCcfg = GridCacheUtils.cachePluginConfiguration(this.ctx.igniteCacheConfiguration(), GridGainCacheConfiguration.class);
        if (ggCcfg != null) {
            this.conflictResolver = ggCcfg.getConflictResolver();
            this.conflictMode = ggCcfg.getConflictResolverMode();
            if (this.conflictResolver != null) {
                this.cctx.kernalContext().resource().injectGeneric(this.conflictResolver);
                this.cctx.kernalContext().resource().injectCacheName(this.conflictResolver, this.cctx.config().getName());
                U.startLifecycleAware(Collections.singleton(this.conflictResolver));
            }
        }
        this.resolverEnabled = this.cctx.dr().receiveEnabled() || this.conflictResolver != null;
    }

    @Override
    protected void stop0(boolean cancel, boolean destroy) {
        super.stop0(cancel, destroy);
        if (this.conflictResolver != null) {
            U.stopLifecycleAware(this.log, Collections.singleton(this.conflictResolver));
        }
    }
}

