/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.conflict;

import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheLazyPlainVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntry;
import org.gridgain.grid.cache.conflict.CacheConflictEntry;
import org.jetbrains.annotations.Nullable;

public class CacheConflictEntryImpl<K, V>
implements CacheConflictEntry<K, V> {
    private final GridCacheVersionedEntry<K, V> entry;
    private final CacheObjectValueContext ctx;

    public CacheConflictEntryImpl(CacheObjectValueContext ctx, GridCacheVersionedEntry<K, V> entry) {
        this.ctx = ctx;
        this.entry = entry;
    }

    @Override
    public K key() {
        return this.entry.key();
    }

    @Override
    public boolean isKeyBinary() {
        return this.entry instanceof GridCacheLazyPlainVersionedEntry && ((GridCacheLazyPlainVersionedEntry)this.entry).isKeyBinary();
    }

    @Override
    public BinaryObject keyBinary() {
        if (this.entry instanceof GridCacheLazyPlainVersionedEntry) {
            return ((GridCacheLazyPlainVersionedEntry)this.entry).keyBinary();
        }
        throw new IgniteException("Entry's key is not binary object. [entry=" + this.entry + ']');
    }

    @Override
    @Nullable
    public V value() {
        return this.entry.value(this.ctx);
    }

    @Override
    public boolean isValueBinary() {
        return this.entry instanceof GridCacheLazyPlainVersionedEntry && ((GridCacheLazyPlainVersionedEntry)this.entry).isValueBinary();
    }

    @Override
    @Nullable
    public BinaryObject valueBinary() {
        if (this.entry instanceof GridCacheLazyPlainVersionedEntry) {
            return ((GridCacheLazyPlainVersionedEntry)this.entry).valueBinary();
        }
        throw new IgniteException("Entry's value is not binary object. [entry=" + this.entry + ']');
    }

    @Override
    public long ttl() {
        return this.entry.ttl();
    }

    @Override
    public long expireTime() {
        return this.entry.expireTime();
    }

    @Override
    public byte dataCenterId() {
        return this.entry.dataCenterId();
    }

    @Override
    public int topologyVersion() {
        return this.entry.topologyVersion();
    }

    @Override
    public long order() {
        return this.entry.order();
    }

    public String toString() {
        return "CacheConflictEntryImpl[entry=" + this.entry + ']';
    }
}

