/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrSenderAttributes;
import org.jetbrains.annotations.Nullable;

public class GridPluginCacheAttributes
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String name;
    private CacheDrSenderAttributes drSndAttrs;
    private CacheConflictMode conflictRslvrMode;
    private String conflictRslvrClsName;
    private boolean drReceiverEnabled;

    public GridPluginCacheAttributes() {
    }

    public GridPluginCacheAttributes(String name, @Nullable GridGainCacheConfiguration cfg) {
        this.name = name;
        if (cfg != null) {
            this.drSndAttrs = cfg.getDrSenderConfiguration() != null ? new CacheDrSenderAttributes(cfg.getDrSenderConfiguration()) : null;
            this.conflictRslvrClsName = GridPluginCacheAttributes.className(cfg.getConflictResolver());
            this.conflictRslvrMode = cfg.getConflictResolverMode();
            this.drReceiverEnabled = cfg.isDrReceiverEnabled();
        }
    }

    public String cacheName() {
        return this.name;
    }

    @Nullable
    public CacheDrSenderAttributes drSendAttributes() {
        return this.drSndAttrs;
    }

    public boolean isDrReceiverEnabled() {
        return this.drReceiverEnabled;
    }

    public CacheConflictMode conflictResolverMode() {
        return this.conflictRslvrMode;
    }

    public String conflictResolverClassName() {
        return this.conflictRslvrClsName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeObject(this.drSndAttrs);
        out.writeBoolean(this.drReceiverEnabled);
        U.writeEnum(out, this.conflictRslvrMode);
        U.writeString(out, this.conflictRslvrClsName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.drSndAttrs = (CacheDrSenderAttributes)in.readObject();
        this.drReceiverEnabled = in.readBoolean();
        this.conflictRslvrMode = CacheConflictMode.fromOrdinal(in.readByte());
        this.conflictRslvrClsName = U.readString(in);
    }

    @Nullable
    private static String className(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }
}

