/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.security;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.GridSecurity;
import org.gridgain.grid.internal.interop.InteropUtils;

public class InteropSecurity
extends PlatformAbstractTarget {
    private static final int OP_GET_AUTH_SUBJECTS = 1;
    private static final int OP_GET_AUTH_SUBJECT = 2;
    private final GridSecurity security;

    public InteropSecurity(PlatformContext platformCtx) {
        super(platformCtx);
        IgniteEx ignite = platformCtx.kernalContext().grid();
        GridGain gridGain = (GridGain)ignite.plugin("GridGain");
        this.security = gridGain.security();
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                Collection<SecuritySubject> subj = this.security.authenticatedSubjects();
                writer.writeInt(subj.size());
                for (SecuritySubject s2 : subj) {
                    InteropUtils.writeSubject(s2, writer);
                }
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 2: {
                SecuritySubject subj = this.security.authenticatedSubject(reader.readUuid());
                if (subj == null) {
                    writer.writeBoolean(false);
                    break;
                }
                writer.writeBoolean(true);
                InteropUtils.writeSubject(subj, writer);
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }
}

