/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.dotnet;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.cache.dr.CacheDrEntry;
import org.gridgain.grid.cache.dr.CacheDrEntryFilter;

public class InteropDotNetCacheDrEntryFilter
implements CacheDrEntryFilter,
LifecycleAware {
    private static final long serialVersionUID = 0L;
    private Object nativeFilter;
    private transient PlatformContext platformCtx;
    private transient long ptr;

    void setNativeFilter(Object nativeFilter) {
        this.nativeFilter = nativeFilter;
    }

    public boolean accept(CacheDrEntry entry) {
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeLong(this.ptr);
            writer.writeObject(entry.key());
            writer.writeObject(entry.value());
            writer.writeByte(entry.dataCenterId());
            out.synchronize();
            boolean bl = this.platformCtx.gateway().pluginCallback(3L, mem, null) != 0L;
            return bl;
        }
    }

    public void initialize(GridKernalContext ctx) throws IgniteCheckedException {
        A.notNull(this.nativeFilter, "nativeFilter");
        this.platformCtx = PlatformUtils.platformContext(ctx.grid());
    }

    @Override
    public void start() throws IgniteException {
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeObject(this.nativeFilter);
            out.synchronize();
            this.ptr = this.platformCtx.gateway().pluginCallback(2L, mem, null);
        }
    }

    @Override
    public void stop() throws IgniteException {
        assert (this.ptr != 0L);
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            out.writeLong(this.ptr);
            out.synchronize();
            this.platformCtx.gateway().pluginCallback(4L, mem, null);
        }
    }

    @IgniteInstanceResource
    public void setIgniteInstance(Ignite ignite) throws IgniteCheckedException {
        this.initialize(((IgniteEx)ignite).context());
    }
}

