/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.dotnet;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.plugin.platform.PlatformCachePluginConfigurationClosure;
import org.apache.ignite.plugin.platform.PlatformCachePluginConfigurationClosureFactory;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.internal.interop.dotnet.InteropDotNetCacheDrEntryFilter;

public class InteropDotNetCacheConfigurationClosure
implements PlatformCachePluginConfigurationClosure,
PlatformCachePluginConfigurationClosureFactory {
    private static final long serialVersionUID = 0L;

    @Override
    public int id() {
        return 1;
    }

    @Override
    public PlatformCachePluginConfigurationClosure create() {
        return this;
    }

    @Override
    public void apply(CacheConfiguration cacheConfiguration, BinaryRawReader reader) {
        ArrayList<GridGainCacheConfiguration> cfgs = new ArrayList<GridGainCacheConfiguration>();
        if (cacheConfiguration.getPluginConfigurations() != null) {
            Collections.addAll(cfgs, cacheConfiguration.getPluginConfigurations());
        }
        GridGainCacheConfiguration plugCfg = this.readCacheConfiguration(reader);
        cfgs.add(plugCfg);
        cacheConfiguration.setPluginConfigurations(cfgs.toArray(new CachePluginConfiguration[cfgs.size()]));
    }

    private GridGainCacheConfiguration readCacheConfiguration(BinaryRawReader r) {
        GridGainCacheConfiguration res = new GridGainCacheConfiguration();
        res.setDrReceiverEnabled(r.readBoolean());
        res.setConflictResolverMode(CacheConflictMode.fromOrdinal(r.readInt()));
        if (r.readBoolean()) {
            res.setDrSenderConfiguration(this.readSenderConfiguration(r));
        }
        return res;
    }

    private CacheDrSenderConfiguration readSenderConfiguration(BinaryRawReader r) {
        CacheDrSenderConfiguration res = new CacheDrSenderConfiguration();
        res.setBatchSendSize(r.readInt());
        res.setBatchSendFrequency(r.readLong());
        res.setMaxBatches(r.readInt());
        res.setMaxBackupQueueSize(r.readInt());
        Object filterObj = ((BinaryRawReaderEx)r).readObjectDetached();
        if (filterObj != null) {
            InteropDotNetCacheDrEntryFilter filter = new InteropDotNetCacheDrEntryFilter();
            filter.setNativeFilter(filterObj);
            res.setEntryFilter(filter);
        }
        res.setSenderGroup(r.readString());
        return res;
    }
}

