/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop;

import java.util.Arrays;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackGateway;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;

public abstract class InteropAbstractConfigurationClosure
implements IgniteClosure<IgniteConfiguration, IgniteConfiguration> {
    private static final long serialVersionUID = 0L;
    protected final PlatformCallbackGateway gate;

    protected InteropAbstractConfigurationClosure(long envPtr) {
        this.gate = new PlatformCallbackGateway(envPtr);
    }

    @Override
    public IgniteConfiguration apply(IgniteConfiguration igniteCfg) {
        assert (igniteCfg != null);
        IgniteConfiguration igniteCfg0 = new IgniteConfiguration(igniteCfg);
        GridGainConfiguration ggCfg = null;
        if (igniteCfg0.getPluginConfigurations() != null) {
            for (PluginConfiguration pluginCfg : igniteCfg0.getPluginConfigurations()) {
                if (!(pluginCfg instanceof GridGainConfiguration)) continue;
                if (ggCfg == null) {
                    ggCfg = (GridGainConfiguration)pluginCfg;
                    continue;
                }
                throw new IgniteException("Only one GridGain plugin configuration is allowed.");
            }
        }
        if (ggCfg == null) {
            ggCfg = new GridGainConfiguration();
            PluginConfiguration[] pluginCfgs = igniteCfg0.getPluginConfigurations();
            if (pluginCfgs != null) {
                PluginConfiguration[] copyPluginCfg = new PluginConfiguration[pluginCfgs.length + 1];
                System.arraycopy(pluginCfgs, 0, copyPluginCfg, 0, pluginCfgs.length);
                copyPluginCfg[pluginCfgs.length] = ggCfg;
                pluginCfgs = copyPluginCfg;
            } else {
                pluginCfgs = new PluginConfiguration[]{ggCfg};
            }
            igniteCfg0.setPluginConfigurations(pluginCfgs);
        }
        this.apply0(igniteCfg0, ggCfg);
        return igniteCfg0;
    }

    protected abstract void apply0(IgniteConfiguration var1, GridGainConfiguration var2);

    protected static void addCachePluginConfig(IgniteConfiguration igniteCfg) {
        CacheConfiguration[] cacheConfigs = igniteCfg.getCacheConfiguration();
        if (cacheConfigs == null) {
            return;
        }
        for (CacheConfiguration cacheCfg : cacheConfigs) {
            CachePluginConfiguration[] configs;
            boolean hasCachePlugin = false;
            for (CachePluginConfiguration cfg : configs = cacheCfg.getPluginConfigurations()) {
                if (!(cfg instanceof GridGainCacheConfiguration)) continue;
                hasCachePlugin = true;
                break;
            }
            if (hasCachePlugin) continue;
            configs = Arrays.copyOf(configs, configs.length + 1);
            configs[configs.length - 1] = new GridGainCacheConfiguration();
            cacheCfg.setPluginConfigurations(configs);
        }
    }
}

