/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.ru.RollingUpgradeModeChangeResult;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.StreamReceiver;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.GridSecurity;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProvider;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.ru.GridGainRollingUpgrade;
import org.jetbrains.annotations.Nullable;

public class GridGainImpl
implements GridGain {
    private final GridPluginProvider provider;

    GridGainImpl(GridPluginProvider provider) {
        this.provider = provider;
    }

    @Override
    public GridGainConfiguration configuration() {
        return this.provider.configuration();
    }

    @Override
    public GridProduct product() {
        return this.provider.license().product();
    }

    @Override
    public GridSecurity security() {
        return this.provider.security().security();
    }

    @Override
    public GridDr dr() {
        return this.provider.dr().dr();
    }

    @Override
    @Nullable
    public GridSnapshot snapshot() {
        return this.provider().databaseManager() == null ? null : this.provider().databaseManager().dbApi();
    }

    @Override
    public GridGainRollingUpgrade rollingUpgrade() {
        return this.provider.rollingUpgrade();
    }

    @Nullable
    public TransactionalDr txDr() {
        return this.provider.txDr();
    }

    @Override
    @Nullable
    public <K, V> IgniteCache<K, V> cache(@Nullable String cacheName, byte dataCenterId) {
        this.checkDataCenterId(dataCenterId);
        IgniteEx ignite = (IgniteEx)this.provider.context().grid();
        GridCacheAdapter cache = ignite.context().cache().internalCache(cacheName);
        if (cache == null) {
            return null;
        }
        IgniteCacheProxyImpl cacheProxy = new IgniteCacheProxyImpl(cache.context(), cache, false);
        return cacheProxy.gatewayWrapper().withDataCenterId(dataCenterId);
    }

    @Override
    @Nullable
    public <K, V> IgniteDataStreamer<K, V> dataStreamer(@Nullable String cacheName, byte dataCenterId) {
        this.checkDataCenterId(dataCenterId);
        IgniteEx ignite = (IgniteEx)this.provider.context().grid();
        DataStreamerImpl str = ignite.context().dataStream().dataStreamer(cacheName);
        str.receiver(new DataCenterIdStreamReceiver(dataCenterId));
        return str;
    }

    public GridPluginProvider provider() {
        return this.provider;
    }

    private void checkDataCenterId(byte dataCenterId) {
        A.ensure(dataCenterId >= 1, "dataCenterId >= 1");
        A.ensure(dataCenterId < 32, "dataCenterId <= 31");
    }

    public RollingUpgradeModeChangeResult enableRollingUpgrade() {
        IgniteEx ignite = (IgniteEx)this.provider.context().grid();
        return ignite.context().rollingUpgrade().setMode(true);
    }

    public RollingUpgradeModeChangeResult disableRollingUpgrade() {
        IgniteEx ignite = (IgniteEx)this.provider.context().grid();
        return ignite.context().rollingUpgrade().setMode(false);
    }

    public RollingUpgradeStatus getRollingUpgradeStatus() {
        IgniteEx ignite = (IgniteEx)this.provider.context().grid();
        return ignite.context().rollingUpgrade().getStatus();
    }

    private static final class DataCenterIdStreamReceiver<K, V>
    implements StreamReceiver<K, V> {
        private static final long serialVersionUID = 0L;
        private final byte dataCenterId;

        private DataCenterIdStreamReceiver(byte dataCenterId) {
            this.dataCenterId = dataCenterId;
        }

        @Override
        public void receive(IgniteCache<K, V> cache, Collection<Map.Entry<K, V>> entries) throws IgniteException {
            IgniteCache<K, V> cache0 = ((IgniteCacheProxy)cache).withDataCenterId(this.dataCenterId);
            for (Map.Entry<K, V> e : entries) {
                cache0.put(e.getKey(), e.getValue());
            }
        }
    }
}

