/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.lucene.util.ArrayUtil;

public abstract class PriorityQueue<T>
implements Iterable<T> {
    private int size = 0;
    private final int maxSize;
    private final T[] heap;

    public PriorityQueue(int maxSize) {
        this(maxSize, () -> null);
    }

    public PriorityQueue(int maxSize, Supplier<T> sentinelObjectSupplier) {
        int heapSize;
        if (0 == maxSize) {
            heapSize = 2;
        } else {
            if (maxSize < 0 || maxSize >= ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("maxSize must be >= 0 and < " + ArrayUtil.MAX_ARRAY_LENGTH + "; got: " + maxSize);
            }
            heapSize = maxSize + 1;
        }
        Object[] h2 = new Object[heapSize];
        this.heap = h2;
        this.maxSize = maxSize;
        T sentinel = sentinelObjectSupplier.get();
        if (sentinel != null) {
            this.heap[1] = sentinel;
            for (int i = 2; i < this.heap.length; ++i) {
                this.heap[i] = sentinelObjectSupplier.get();
            }
            this.size = maxSize;
        }
    }

    protected abstract boolean lessThan(T var1, T var2);

    public final T add(T element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap(this.size);
        return this.heap[1];
    }

    public T insertWithOverflow(T element) {
        if (this.size < this.maxSize) {
            this.add(element);
            return null;
        }
        if (this.size > 0 && !this.lessThan(element, this.heap[1])) {
            T ret = this.heap[1];
            this.heap[1] = element;
            this.updateTop();
            return ret;
        }
        return element;
    }

    public final T top() {
        return this.heap[1];
    }

    public final T pop() {
        if (this.size > 0) {
            T result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap(1);
            return result;
        }
        return null;
    }

    public final T updateTop() {
        this.downHeap(1);
        return this.heap[1];
    }

    public final T updateTop(T newTop) {
        this.heap[1] = newTop;
        return this.updateTop();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    public final boolean remove(T element) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.heap[i] != element) continue;
            this.heap[i] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            if (i <= this.size && !this.upHeap(i)) {
                this.downHeap(i);
            }
            return true;
        }
        return false;
    }

    private final boolean upHeap(int origPos) {
        int i = origPos;
        T node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
        return i != origPos;
    }

    private final void downHeap(int i) {
        T node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    protected final Object[] getHeapArray() {
        return this.heap;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 1;

            @Override
            public boolean hasNext() {
                return this.i <= PriorityQueue.this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PriorityQueue.this.heap[this.i++];
            }
        };
    }
}

