/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.IndriAndQuery;
import org.apache.lucene.search.IndriAndScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class IndriAndWeight
extends Weight {
    private final IndriAndQuery query;
    private final ArrayList<Weight> weights;
    private final ScoreMode scoreMode;
    private final float boost;

    public IndriAndWeight(IndriAndQuery query2, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super(query2);
        this.query = query2;
        this.boost = boost;
        this.scoreMode = scoreMode;
        this.weights = new ArrayList();
        for (BooleanClause c : query2) {
            Weight w = searcher.createWeight(c.getQuery(), scoreMode, 1.0f);
            this.weights.add(w);
        }
    }

    private Scorer getScorer(LeafReaderContext context) throws IOException {
        ArrayList<Scorer> subScorers = new ArrayList<Scorer>();
        for (Weight w : this.weights) {
            Scorer scorer = w.scorer(context);
            if (scorer == null) continue;
            subScorers.add(scorer);
        }
        if (subScorers.isEmpty()) {
            return null;
        }
        Scorer scorer = (Scorer)subScorers.get(0);
        if (subScorers.size() > 1) {
            scorer = new IndriAndScorer(this, subScorers, this.scoreMode, this.boost);
        }
        return scorer;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        for (Weight weight : this.weights) {
            weight.extractTerms(terms);
        }
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        return this.getScorer(context);
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        Scorer scorer = this.getScorer(context);
        if (scorer != null) {
            Weight.DefaultBulkScorer bulkScorer = new Weight.DefaultBulkScorer(scorer);
            return bulkScorer;
        }
        return null;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        for (Weight w : this.weights) {
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        boolean fail = false;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                subs.add(e);
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.getQuery().toString() + ")", e));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        Scorer scorer = this.scorer(context);
        if (scorer != null) {
            int advanced = scorer.iterator().advance(doc);
            assert (advanced == doc);
            return Explanation.match((Number)Float.valueOf(scorer.score()), "sum of:", subs);
        }
        return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
    }
}

