/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.sandbox.search.QueryProfilerBreakdown;
import org.apache.lucene.sandbox.search.QueryProfilerScorer;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

class QueryProfilerWeight
extends Weight {
    private final Weight subQueryWeight;
    private final QueryProfilerBreakdown profile;

    public QueryProfilerWeight(Query query2, Weight subQueryWeight, QueryProfilerBreakdown profile2) {
        super(query2);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile2;
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier supplier = this.scorerSupplier(context);
        if (supplier == null) {
            return null;
        }
        return supplier.get(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final QueryProfilerTimer timer = this.profile.getTimer(QueryProfilerTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.subQueryWeight.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        final QueryProfilerWeight weight = this;
        return new ScorerSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    QueryProfilerScorer queryProfilerScorer = new QueryProfilerScorer(weight, subQueryScorerSupplier.get(loadCost), QueryProfilerWeight.this.profile);
                    return queryProfilerScorer;
                }
                finally {
                    timer.stop();
                }
            }

            @Override
            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        return super.bulkScorer(context);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.subQueryWeight.extractTerms(terms);
    }
}

