/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene86;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.bkd.BKDReader;

public class Lucene86PointsReader
extends PointsReader
implements Closeable {
    final IndexInput indexIn;
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, BKDReader> readers = new HashMap<Integer, BKDReader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene86PointsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "kdm");
        String indexFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "kdi");
        String dataFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "kdd");
        boolean success = false;
        try {
            long dataLength;
            long indexLength;
            block21: {
                this.indexIn = readState.directory.openInput(indexFileName, readState.context);
                CodecUtil.checkIndexHeader(this.indexIn, "Lucene86PointsFormatIndex", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                this.dataIn = readState.directory.openInput(dataFileName, readState.context);
                CodecUtil.checkIndexHeader(this.dataIn, "Lucene86PointsFormatData", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                indexLength = -1L;
                dataLength = -1L;
                try (ChecksumIndexInput metaIn = readState.directory.openChecksumInput(metaFileName, readState.context);){
                    Throwable priorE = null;
                    try {
                        int fieldNumber;
                        CodecUtil.checkIndexHeader(metaIn, "Lucene86PointsFormatMeta", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                        while ((fieldNumber = metaIn.readInt()) != -1) {
                            if (fieldNumber < 0) {
                                throw new CorruptIndexException("Illegal field number: " + fieldNumber, metaIn);
                            }
                            BKDReader reader = new BKDReader(metaIn, this.indexIn, this.dataIn);
                            this.readers.put(fieldNumber, reader);
                        }
                        indexLength = metaIn.readLong();
                        dataLength = metaIn.readLong();
                    }
                    catch (Throwable t2) {
                        try {
                            priorE = t2;
                            break block21;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter(metaIn, priorE);
                        }
                    }
                    CodecUtil.checkFooter(metaIn, priorE);
                }
            }
            CodecUtil.retrieveChecksum(this.indexIn, indexLength);
            CodecUtil.retrieveChecksum(this.dataIn, dataLength);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexIn);
        CodecUtil.checksumEntireFile(this.dataIn);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.indexIn, this.dataIn);
        this.readers.clear();
    }
}

