/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blocktree.CompressionAlgorithm;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.FutureObjects;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.compress.LZ4;
import org.apache.lucene.util.compress.LowercaseAsciiCompression;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public final class BlockTreeTermsWriter
extends FieldsConsumer {
    public static final int DEFAULT_MIN_BLOCK_SIZE = 25;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 48;
    private final IndexOutput metaOut;
    private final IndexOutput termsOut;
    private final IndexOutput indexOut;
    final int maxDoc;
    final int minItemsInBlock;
    final int maxItemsInBlock;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    private final List<ByteBuffersDataOutput> fields = new ArrayList<ByteBuffersDataOutput>();
    private final RAMOutputStream scratchBytes = new RAMOutputStream();
    private final IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
    static final BytesRef EMPTY_BYTES_REF = new BytesRef();
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTreeTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock) throws IOException {
        BlockTreeTermsWriter.validateSettings(minItemsInBlock, maxItemsInBlock);
        this.minItemsInBlock = minItemsInBlock;
        this.maxItemsInBlock = maxItemsInBlock;
        this.maxDoc = state.segmentInfo.maxDoc();
        this.fieldInfos = state.fieldInfos;
        this.postingsWriter = postingsWriter;
        String termsName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tim");
        this.termsOut = state.directory.createOutput(termsName, state.context);
        boolean success = false;
        IndexOutput metaOut = null;
        IndexOutput indexOut = null;
        try {
            CodecUtil.writeIndexHeader(this.termsOut, "BlockTreeTermsDict", 6, state.segmentInfo.getId(), state.segmentSuffix);
            String indexName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tip");
            indexOut = state.directory.createOutput(indexName, state.context);
            CodecUtil.writeIndexHeader(indexOut, "BlockTreeTermsIndex", 6, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tmd");
            metaOut = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(metaOut, "BlockTreeTermsMeta", 6, state.segmentInfo.getId(), state.segmentSuffix);
            postingsWriter.init(metaOut, state);
            this.metaOut = metaOut;
            this.indexOut = indexOut;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(metaOut, this.termsOut, indexOut);
            throw throwable;
        }
    }

    public static void validateSettings(int minItemsInBlock, int maxItemsInBlock) {
        if (minItemsInBlock <= 1) {
            throw new IllegalArgumentException("minItemsInBlock must be >= 2; got " + minItemsInBlock);
        }
        if (minItemsInBlock > maxItemsInBlock) {
            throw new IllegalArgumentException("maxItemsInBlock must be >= minItemsInBlock; got maxItemsInBlock=" + maxItemsInBlock + " minItemsInBlock=" + minItemsInBlock);
        }
        if (2 * (minItemsInBlock - 1) > maxItemsInBlock) {
            throw new IllegalArgumentException("maxItemsInBlock must be at least 2*(minItemsInBlock-1); got maxItemsInBlock=" + maxItemsInBlock + " minItemsInBlock=" + minItemsInBlock);
        }
    }

    @Override
    public void write(Fields fields, NormsProducer norms) throws IOException {
        String lastField = null;
        for (String field : fields) {
            BytesRef term;
            assert (lastField == null || lastField.compareTo(field) < 0);
            lastField = field;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(this.fieldInfos.fieldInfo(field));
            while ((term = termsEnum.next()) != null) {
                termsWriter.write(term, termsEnum, norms);
            }
            termsWriter.finish();
        }
    }

    static long encodeOutput(long fp, boolean hasTerms, boolean isFloor) {
        assert (fp < 0x4000000000000000L);
        return fp << 2 | (long)(hasTerms ? 2 : 0) | (long)(isFloor ? 1 : 0);
    }

    static String brToString(BytesRef b) {
        if (b == null) {
            return "(null)";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t2) {
            return b.toString();
        }
    }

    static String brToString(byte[] b) {
        return BlockTreeTermsWriter.brToString(new BytesRef(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                boolean success = false;
                try {
                    this.metaOut.writeVInt(this.fields.size());
                    for (ByteBuffersDataOutput fieldMeta : this.fields) {
                        fieldMeta.copyTo(this.metaOut);
                    }
                    CodecUtil.writeFooter(this.indexOut);
                    this.metaOut.writeLong(this.indexOut.getFilePointer());
                    CodecUtil.writeFooter(this.termsOut);
                    this.metaOut.writeLong(this.termsOut.getFilePointer());
                    CodecUtil.writeFooter(this.metaOut);
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.metaOut, this.termsOut, this.indexOut, this.postingsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(this.metaOut, this.termsOut, this.indexOut, this.postingsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(this.metaOut, this.termsOut, this.indexOut, this.postingsWriter);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.metaOut, this.termsOut, this.indexOut, this.postingsWriter);
        }
    }

    private static void writeBytesRef(DataOutput out, BytesRef bytes) throws IOException {
        out.writeVInt(bytes.length);
        out.writeBytes(bytes.bytes, bytes.offset, bytes.length);
    }

    class TermsWriter {
        private final FieldInfo fieldInfo;
        private long numTerms;
        final FixedBitSet docsSeen;
        long sumTotalTermFreq;
        long sumDocFreq;
        private final BytesRefBuilder lastTerm = new BytesRefBuilder();
        private int[] prefixStarts = new int[8];
        private final List<PendingEntry> pending = new ArrayList<PendingEntry>();
        private final List<PendingBlock> newBlocks = new ArrayList<PendingBlock>();
        private PendingTerm firstPendingTerm;
        private PendingTerm lastPendingTerm;
        private final RAMOutputStream suffixLengthsWriter = new RAMOutputStream();
        private final BytesRefBuilder suffixWriter = new BytesRefBuilder();
        private final RAMOutputStream statsWriter = new RAMOutputStream();
        private final RAMOutputStream metaWriter = new RAMOutputStream();
        private final RAMOutputStream spareWriter = new RAMOutputStream();
        private byte[] spareBytes = BytesRef.EMPTY_BYTES;
        private final LZ4.HighCompressionHashTable compressionHashTable = new LZ4.HighCompressionHashTable();

        void writeBlocks(int prefixLength, int count) throws IOException {
            assert (count > 0);
            assert (prefixLength > 0 || count == this.pending.size());
            int lastSuffixLeadLabel = -1;
            boolean hasTerms = false;
            boolean hasSubBlocks = false;
            int start = this.pending.size() - count;
            int end = this.pending.size();
            int nextBlockStart = start;
            int nextFloorLeadLabel = -1;
            for (int i = start; i < end; ++i) {
                int suffixLeadLabel;
                PendingEntry ent = this.pending.get(i);
                if (ent.isTerm) {
                    PendingTerm term = (PendingTerm)ent;
                    if (term.termBytes.length == prefixLength) {
                        assert (lastSuffixLeadLabel == -1) : "i=" + i + " lastSuffixLeadLabel=" + lastSuffixLeadLabel;
                        suffixLeadLabel = -1;
                    } else {
                        suffixLeadLabel = term.termBytes[prefixLength] & 0xFF;
                    }
                } else {
                    PendingBlock block = (PendingBlock)ent;
                    assert (block.prefix.length > prefixLength);
                    suffixLeadLabel = block.prefix.bytes[block.prefix.offset + prefixLength] & 0xFF;
                }
                if (suffixLeadLabel != lastSuffixLeadLabel) {
                    int itemsInBlock = i - nextBlockStart;
                    if (itemsInBlock >= BlockTreeTermsWriter.this.minItemsInBlock && end - nextBlockStart > BlockTreeTermsWriter.this.maxItemsInBlock) {
                        boolean isFloor = itemsInBlock < count;
                        this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, i, hasTerms, hasSubBlocks));
                        hasTerms = false;
                        hasSubBlocks = false;
                        nextFloorLeadLabel = suffixLeadLabel;
                        nextBlockStart = i;
                    }
                    lastSuffixLeadLabel = suffixLeadLabel;
                }
                if (ent.isTerm) {
                    hasTerms = true;
                    continue;
                }
                hasSubBlocks = true;
            }
            if (nextBlockStart < end) {
                int itemsInBlock = end - nextBlockStart;
                boolean isFloor = itemsInBlock < count;
                this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, end, hasTerms, hasSubBlocks));
            }
            assert (!this.newBlocks.isEmpty());
            PendingBlock firstBlock = this.newBlocks.get(0);
            assert (firstBlock.isFloor || this.newBlocks.size() == 1);
            firstBlock.compileIndex(this.newBlocks, BlockTreeTermsWriter.this.scratchBytes, BlockTreeTermsWriter.this.scratchIntsRef);
            this.pending.subList(this.pending.size() - count, this.pending.size()).clear();
            this.pending.add(firstBlock);
            this.newBlocks.clear();
        }

        private boolean allEqual(byte[] b, int startOffset, int endOffset, byte value) {
            FutureObjects.checkFromToIndex(startOffset, endOffset, b.length);
            for (int i = startOffset; i < endOffset; ++i) {
                if (b[i] == value) continue;
                return false;
            }
            return true;
        }

        private PendingBlock writeBlock(int prefixLength, boolean isFloor, int floorLeadLabel, int start, int end, boolean hasTerms, boolean hasSubBlocks) throws IOException {
            PendingTerm term;
            int i;
            StatsWriter statsWriter;
            ArrayList<FST<BytesRef>> subIndices;
            assert (end > start);
            long startFP = BlockTreeTermsWriter.this.termsOut.getFilePointer();
            boolean hasFloorLeadLabel = isFloor && floorLeadLabel != -1;
            BytesRef prefix = new BytesRef(prefixLength + (hasFloorLeadLabel ? 1 : 0));
            System.arraycopy(this.lastTerm.get().bytes, 0, prefix.bytes, 0, prefixLength);
            prefix.length = prefixLength;
            int numEntries = end - start;
            int code = numEntries << 1;
            if (end == this.pending.size()) {
                code |= 1;
            }
            BlockTreeTermsWriter.this.termsOut.writeVInt(code);
            boolean isLeafBlock = !hasSubBlocks;
            boolean absolute = true;
            if (isLeafBlock) {
                subIndices = null;
                statsWriter = new StatsWriter(this.statsWriter, this.fieldInfo.getIndexOptions() != IndexOptions.DOCS);
                for (i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    assert (ent.isTerm) : "i=" + i;
                    term = (PendingTerm)ent;
                    assert (StringHelper.startsWith(term.termBytes, prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                    BlockTermState state = term.state;
                    int suffix = term.termBytes.length - prefixLength;
                    this.suffixLengthsWriter.writeVInt(suffix);
                    this.suffixWriter.append(term.termBytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                    statsWriter.add(state.docFreq, state.totalTermFreq);
                    BlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.metaWriter, this.fieldInfo, state, absolute);
                    absolute = false;
                }
                statsWriter.finish();
            } else {
                subIndices = new ArrayList<FST<BytesRef>>();
                statsWriter = new StatsWriter(this.statsWriter, this.fieldInfo.getIndexOptions() != IndexOptions.DOCS);
                for (i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    if (ent.isTerm) {
                        term = (PendingTerm)ent;
                        assert (StringHelper.startsWith(term.termBytes, prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                        BlockTermState state = term.state;
                        int suffix = term.termBytes.length - prefixLength;
                        this.suffixLengthsWriter.writeVInt(suffix << 1);
                        this.suffixWriter.append(term.termBytes, prefixLength, suffix);
                        statsWriter.add(state.docFreq, state.totalTermFreq);
                        BlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.metaWriter, this.fieldInfo, state, absolute);
                        absolute = false;
                        continue;
                    }
                    PendingBlock block = (PendingBlock)ent;
                    assert (StringHelper.startsWith(block.prefix, prefix));
                    int suffix = block.prefix.length - prefixLength;
                    assert (StringHelper.startsWith(block.prefix, prefix));
                    assert (suffix > 0);
                    this.suffixLengthsWriter.writeVInt(suffix << 1 | 1);
                    this.suffixWriter.append(block.prefix.bytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (block.prefix.bytes[prefixLength] & 0xFF) >= floorLeadLabel) : "floorLeadLabel=" + floorLeadLabel + " suffixLead=" + (block.prefix.bytes[prefixLength] & 0xFF);
                    assert (block.fp < startFP);
                    this.suffixLengthsWriter.writeVLong(startFP - block.fp);
                    subIndices.add(block.index);
                }
                statsWriter.finish();
                assert (subIndices.size() != 0);
            }
            CompressionAlgorithm compressionAlg = CompressionAlgorithm.NO_COMPRESSION;
            if ((long)this.suffixWriter.length() > 2L * (long)numEntries && prefixLength > 2) {
                if ((long)this.suffixWriter.length() > 6L * (long)numEntries) {
                    LZ4.compress(this.suffixWriter.bytes(), 0, this.suffixWriter.length(), this.spareWriter, this.compressionHashTable);
                    if (this.spareWriter.getFilePointer() < (long)(this.suffixWriter.length() - (this.suffixWriter.length() >>> 2))) {
                        compressionAlg = CompressionAlgorithm.LZ4;
                    }
                }
                if (compressionAlg == CompressionAlgorithm.NO_COMPRESSION) {
                    this.spareWriter.reset();
                    if (this.spareBytes.length < this.suffixWriter.length()) {
                        this.spareBytes = new byte[ArrayUtil.oversize(this.suffixWriter.length(), 1)];
                    }
                    if (LowercaseAsciiCompression.compress(this.suffixWriter.bytes(), this.suffixWriter.length(), this.spareBytes, this.spareWriter)) {
                        compressionAlg = CompressionAlgorithm.LOWERCASE_ASCII;
                    }
                }
            }
            long token = (long)this.suffixWriter.length() << 3;
            if (isLeafBlock) {
                token |= 4L;
            }
            BlockTreeTermsWriter.this.termsOut.writeVLong(token |= (long)compressionAlg.code);
            if (compressionAlg == CompressionAlgorithm.NO_COMPRESSION) {
                BlockTreeTermsWriter.this.termsOut.writeBytes(this.suffixWriter.bytes(), this.suffixWriter.length());
            } else {
                this.spareWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            }
            this.suffixWriter.setLength(0);
            this.spareWriter.reset();
            int numSuffixBytes = Math.toIntExact(this.suffixLengthsWriter.getFilePointer());
            this.spareBytes = ArrayUtil.grow(this.spareBytes, numSuffixBytes);
            this.suffixLengthsWriter.writeTo(new ByteArrayDataOutput(this.spareBytes));
            this.suffixLengthsWriter.reset();
            if (this.allEqual(this.spareBytes, 1, numSuffixBytes, this.spareBytes[0])) {
                BlockTreeTermsWriter.this.termsOut.writeVInt(numSuffixBytes << 1 | 1);
                BlockTreeTermsWriter.this.termsOut.writeByte(this.spareBytes[0]);
            } else {
                BlockTreeTermsWriter.this.termsOut.writeVInt(numSuffixBytes << 1);
                BlockTreeTermsWriter.this.termsOut.writeBytes(this.spareBytes, numSuffixBytes);
            }
            int numStatsBytes = Math.toIntExact(this.statsWriter.getFilePointer());
            BlockTreeTermsWriter.this.termsOut.writeVInt(numStatsBytes);
            this.statsWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.statsWriter.reset();
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)this.metaWriter.getFilePointer());
            this.metaWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.metaWriter.reset();
            if (hasFloorLeadLabel) {
                prefix.bytes[prefix.length++] = (byte)floorLeadLabel;
            }
            return new PendingBlock(prefix, startFP, hasTerms, isFloor, floorLeadLabel, subIndices);
        }

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            assert (fieldInfo.getIndexOptions() != IndexOptions.NONE);
            this.docsSeen = new FixedBitSet(BlockTreeTermsWriter.this.maxDoc);
            BlockTreeTermsWriter.this.postingsWriter.setField(fieldInfo);
        }

        public void write(BytesRef text, TermsEnum termsEnum, NormsProducer norms) throws IOException {
            BlockTermState state = BlockTreeTermsWriter.this.postingsWriter.writeTerm(text, termsEnum, this.docsSeen, norms);
            if (state != null) {
                assert (state.docFreq != 0);
                assert (this.fieldInfo.getIndexOptions() == IndexOptions.DOCS || state.totalTermFreq >= (long)state.docFreq) : "postingsWriter=" + BlockTreeTermsWriter.this.postingsWriter;
                this.pushTerm(text);
                PendingTerm term = new PendingTerm(text, state);
                this.pending.add(term);
                this.sumDocFreq += (long)state.docFreq;
                this.sumTotalTermFreq += state.totalTermFreq;
                ++this.numTerms;
                if (this.firstPendingTerm == null) {
                    this.firstPendingTerm = term;
                }
                this.lastPendingTerm = term;
            }
        }

        private void pushTerm(BytesRef text) throws IOException {
            int i;
            int prefixLength = FutureArrays.mismatch(this.lastTerm.bytes(), 0, this.lastTerm.length(), text.bytes, text.offset, text.offset + text.length);
            if (prefixLength == -1) {
                assert (this.lastTerm.length() == 0);
                prefixLength = 0;
            }
            for (i = this.lastTerm.length() - 1; i >= prefixLength; --i) {
                int prefixTopSize = this.pending.size() - this.prefixStarts[i];
                if (prefixTopSize < BlockTreeTermsWriter.this.minItemsInBlock) continue;
                this.writeBlocks(i + 1, prefixTopSize);
                int n = i;
                this.prefixStarts[n] = this.prefixStarts[n] - (prefixTopSize - 1);
            }
            if (this.prefixStarts.length < text.length) {
                this.prefixStarts = ArrayUtil.grow(this.prefixStarts, text.length);
            }
            for (i = prefixLength; i < text.length; ++i) {
                this.prefixStarts[i] = this.pending.size();
            }
            this.lastTerm.copyBytes(text);
        }

        public void finish() throws IOException {
            if (this.numTerms > 0L) {
                this.pushTerm(new BytesRef());
                this.pushTerm(new BytesRef());
                this.writeBlocks(0, this.pending.size());
                assert (this.pending.size() == 1 && !this.pending.get((int)0).isTerm) : "pending.size()=" + this.pending.size() + " pending=" + this.pending;
                PendingBlock root = (PendingBlock)this.pending.get(0);
                assert (root.prefix.length == 0);
                BytesRef rootCode = root.index.getEmptyOutput();
                assert (rootCode != null);
                ByteBuffersDataOutput metaOut = new ByteBuffersDataOutput();
                BlockTreeTermsWriter.this.fields.add(metaOut);
                metaOut.writeVInt(this.fieldInfo.number);
                metaOut.writeVLong(this.numTerms);
                metaOut.writeVInt(rootCode.length);
                metaOut.writeBytes(rootCode.bytes, rootCode.offset, rootCode.length);
                assert (this.fieldInfo.getIndexOptions() != IndexOptions.NONE);
                if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                    metaOut.writeVLong(this.sumTotalTermFreq);
                }
                metaOut.writeVLong(this.sumDocFreq);
                metaOut.writeVInt(this.docsSeen.cardinality());
                BlockTreeTermsWriter.writeBytesRef(metaOut, new BytesRef(this.firstPendingTerm.termBytes));
                BlockTreeTermsWriter.writeBytesRef(metaOut, new BytesRef(this.lastPendingTerm.termBytes));
                metaOut.writeVLong(BlockTreeTermsWriter.this.indexOut.getFilePointer());
                root.index.save(metaOut, BlockTreeTermsWriter.this.indexOut);
            } else {
                assert (this.sumTotalTermFreq == 0L || this.fieldInfo.getIndexOptions() == IndexOptions.DOCS && this.sumTotalTermFreq == -1L);
                assert (this.sumDocFreq == 0L);
                assert (this.docsSeen.cardinality() == 0);
            }
        }
    }

    private static class StatsWriter {
        private final DataOutput out;
        private final boolean hasFreqs;
        private int singletonCount;

        StatsWriter(DataOutput out, boolean hasFreqs) {
            this.out = out;
            this.hasFreqs = hasFreqs;
        }

        void add(int df, long ttf) throws IOException {
            if (!(df != 1 || this.hasFreqs && ttf != 1L)) {
                ++this.singletonCount;
            } else {
                this.finish();
                this.out.writeVInt(df << 1);
                if (this.hasFreqs) {
                    this.out.writeVLong(ttf - (long)df);
                }
            }
        }

        void finish() throws IOException {
            if (this.singletonCount > 0) {
                this.out.writeVInt(this.singletonCount - 1 << 1 | 1);
                this.singletonCount = 0;
            }
        }
    }

    private static final class PendingBlock
    extends PendingEntry {
        public final BytesRef prefix;
        public final long fp;
        public FST<BytesRef> index;
        public List<FST<BytesRef>> subIndices;
        public final boolean hasTerms;
        public final boolean isFloor;
        public final int floorLeadByte;

        public PendingBlock(BytesRef prefix, long fp, boolean hasTerms, boolean isFloor, int floorLeadByte, List<FST<BytesRef>> subIndices) {
            super(false);
            this.prefix = prefix;
            this.fp = fp;
            this.hasTerms = hasTerms;
            this.isFloor = isFloor;
            this.floorLeadByte = floorLeadByte;
            this.subIndices = subIndices;
        }

        public String toString() {
            return "BLOCK: prefix=" + BlockTreeTermsWriter.brToString(this.prefix);
        }

        public void compileIndex(List<PendingBlock> blocks, RAMOutputStream scratchBytes, IntsRefBuilder scratchIntsRef) throws IOException {
            assert (this.isFloor && blocks.size() > 1 || !this.isFloor && blocks.size() == 1) : "isFloor=" + this.isFloor + " blocks=" + blocks;
            assert (this == blocks.get(0));
            assert (scratchBytes.getFilePointer() == 0L);
            scratchBytes.writeVLong(BlockTreeTermsWriter.encodeOutput(this.fp, this.hasTerms, this.isFloor));
            if (this.isFloor) {
                scratchBytes.writeVInt(blocks.size() - 1);
                for (int i = 1; i < blocks.size(); ++i) {
                    PendingBlock sub = blocks.get(i);
                    assert (sub.floorLeadByte != -1);
                    scratchBytes.writeByte((byte)sub.floorLeadByte);
                    assert (sub.fp > this.fp);
                    scratchBytes.writeVLong(sub.fp - this.fp << 1 | (long)(sub.hasTerms ? 1 : 0));
                }
            }
            ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
            Builder<BytesRef> indexBuilder = new Builder<BytesRef>(FST.INPUT_TYPE.BYTE1, 0, 0, true, false, Integer.MAX_VALUE, outputs, true, 15);
            byte[] bytes = new byte[(int)scratchBytes.getFilePointer()];
            assert (bytes.length > 0);
            scratchBytes.writeTo(bytes, 0);
            indexBuilder.add(Util.toIntsRef(this.prefix, scratchIntsRef), new BytesRef(bytes, 0, bytes.length));
            scratchBytes.reset();
            for (PendingBlock block : blocks) {
                if (block.subIndices == null) continue;
                for (FST<BytesRef> subIndex : block.subIndices) {
                    this.append(indexBuilder, subIndex, scratchIntsRef);
                }
                block.subIndices = null;
            }
            this.index = indexBuilder.finish();
            assert (this.subIndices == null);
        }

        private void append(Builder<BytesRef> builder, FST<BytesRef> subIndex, IntsRefBuilder scratchIntsRef) throws IOException {
            BytesRefFSTEnum.InputOutput<BytesRef> indexEnt;
            BytesRefFSTEnum<BytesRef> subIndexEnum = new BytesRefFSTEnum<BytesRef>(subIndex);
            while ((indexEnt = subIndexEnum.next()) != null) {
                builder.add(Util.toIntsRef(indexEnt.input, scratchIntsRef), (BytesRef)indexEnt.output);
            }
        }
    }

    private static final class PendingTerm
    extends PendingEntry {
        public final byte[] termBytes;
        public final BlockTermState state;

        public PendingTerm(BytesRef term, BlockTermState state) {
            super(true);
            this.termBytes = new byte[term.length];
            System.arraycopy(term.bytes, term.offset, this.termBytes, 0, term.length);
            this.state = state;
        }

        public String toString() {
            return "TERM: " + BlockTreeTermsWriter.brToString(this.termBytes);
        }
    }

    private static class PendingEntry {
        public final boolean isTerm;

        protected PendingEntry(boolean isTerm) {
            this.isTerm = isTerm;
        }
    }
}

