/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.mxbean.WorkersControlMXBean;

public class WorkersControlMXBeanImpl
implements WorkersControlMXBean {
    private final WorkersRegistry workerRegistry;

    public WorkersControlMXBeanImpl(WorkersRegistry registry) {
        this.workerRegistry = registry;
    }

    @Override
    public List<String> getWorkerNames() {
        ArrayList<String> names = new ArrayList<String>(this.workerRegistry.names());
        Collections.sort(names);
        return names;
    }

    @Override
    public boolean terminateWorker(String name) {
        GridWorker w = this.workerRegistry.worker(name);
        if (w == null || w.isCancelled()) {
            return false;
        }
        Thread t2 = w.runner();
        if (t2 == null) {
            return false;
        }
        t2.interrupt();
        return true;
    }

    @Override
    public boolean stopThreadByUniqueName(String name) {
        Thread[] threads = (Thread[])Thread.getAllStackTraces().keySet().stream().filter(t2 -> Objects.equals(t2.getName(), name)).toArray(Thread[]::new);
        if (threads.length != 1) {
            return false;
        }
        threads[0].stop();
        return true;
    }

    @Override
    public boolean stopThreadById(long id) {
        Thread[] threads = (Thread[])Thread.getAllStackTraces().keySet().stream().filter(t2 -> t2.getId() == id).toArray(Thread[]::new);
        if (threads.length != 1) {
            return false;
        }
        threads[0].stop();
        return true;
    }
}

