/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.annotation.InterruptibleVisorTask;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
@InterruptibleVisorTask
public class VisorValidateIndexesTask
extends VisorMultiNodeTask<VisorValidateIndexesTaskArg, VisorValidateIndexesTaskResult, VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected VisorValidateIndexesTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        HashMap<UUID, VisorValidateIndexesJobResult> jobResults = new HashMap<UUID, VisorValidateIndexesJobResult>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            jobResults.put(res.getNode().id(), (VisorValidateIndexesJobResult)res.getData());
        }
        return new VisorValidateIndexesTaskResult(jobResults, exceptions);
    }

    @Override
    protected VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> job(VisorValidateIndexesTaskArg arg) {
        return new VisorValidateIndexesJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorValidateIndexesTaskArg> arg) {
        HashSet<UUID> nodeIds;
        Collection<ClusterNode> srvNodes = this.ignite.cluster().forServers().nodes();
        ArrayList<UUID> ret = new ArrayList<UUID>(srvNodes.size());
        VisorValidateIndexesTaskArg taskArg = arg.getArgument();
        HashSet<UUID> hashSet = nodeIds = taskArg.getNodes() != null ? new HashSet<UUID>(taskArg.getNodes()) : null;
        if (nodeIds == null) {
            for (ClusterNode node : srvNodes) {
                ret.add(node.id());
            }
        } else {
            for (ClusterNode node : srvNodes) {
                if (!nodeIds.contains(node.id())) continue;
                ret.add(node.id());
            }
        }
        return ret;
    }

    private static class VisorValidateIndexesJob
    extends VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        private IgniteLogger log;

        protected VisorValidateIndexesJob(@Nullable VisorValidateIndexesTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorValidateIndexesJobResult run(@Nullable VisorValidateIndexesTaskArg arg) throws IgniteException {
            try {
                ValidateIndexesClosure clo = new ValidateIndexesClosure(this::isCancelled, arg.getCaches(), arg.getCheckFirst(), arg.getCheckThrough(), arg.\u0441heckCrc(), arg.checkSizes());
                this.ignite.context().resource().injectGeneric(clo);
                return clo.call();
            }
            catch (Exception e) {
                this.cancel();
                throw new IgniteException(e);
            }
        }

        @Override
        public void cancel() {
            this.log.warning("Index validation was cancelled.");
            super.cancel();
        }

        public String toString() {
            return S.toString(VisorValidateIndexesJob.class, this);
        }
    }
}

