/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.visor.query.VisorQueryField;
import org.apache.ignite.lang.IgniteFuture;

public class VisorQueryHolder
implements AutoCloseable {
    private static final String SQL_QRY_PREFIX = "VISOR_SQL_QUERY";
    private static final String SCAN_QRY_PREFIX = "VISOR_SCAN_QUERY";
    private final String qryId;
    private final GridQueryCancel cancel;
    private volatile List<VisorQueryField> cols;
    private volatile Throwable err;
    private volatile long duration;
    private volatile boolean accessed;
    private volatile QueryCursor cur;
    private volatile Iterator itr;
    private final GridFutureAdapter<Void> readyFut = new GridFutureAdapter();

    public static boolean isSqlQuery(String qryId) {
        return qryId.startsWith(SQL_QRY_PREFIX);
    }

    VisorQueryHolder(boolean sqlQry, QueryCursor cur, GridQueryCancel cancel) {
        this.cur = cur;
        this.cancel = cancel;
        this.qryId = (sqlQry ? SQL_QRY_PREFIX : SCAN_QRY_PREFIX) + "-" + UUID.randomUUID();
    }

    public String getQueryID() {
        return this.qryId;
    }

    public synchronized Iterator getIterator() {
        assert (this.cur != null);
        if (this.itr == null) {
            this.itr = this.cur.iterator();
        }
        return this.itr;
    }

    public List<VisorQueryField> getColumns() {
        return this.cols;
    }

    public void complete(QueryCursor cur, long duration, List<VisorQueryField> cols) {
        this.cur = cur;
        this.duration = duration;
        this.cols = cols;
        this.accessed = false;
        this.readyFut.onDone();
    }

    public IgniteFuture<Void> readyFuture() {
        return new IgniteFutureImpl<Void>(this.readyFut);
    }

    @Override
    public void close() {
        if (this.cur != null) {
            this.cur.close();
        }
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    public Throwable getErr() {
        return this.err;
    }

    public void setError(Throwable err) {
        this.err = err;
        if (this.cur != null) {
            this.cur.close();
        }
        this.readyFut.onDone(err);
    }

    public boolean isAccessed() {
        return this.accessed;
    }

    public void setAccessed(boolean accessed) {
        this.accessed = accessed;
    }

    public long duration() {
        return this.duration;
    }
}

