/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.node.VisorNodeEventsCollectorTaskArg;
import org.apache.ignite.internal.visor.util.VisorEventMapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;

@GridInternal
public class VisorNodeEventsCollectorTask
extends VisorMultiNodeTask<VisorNodeEventsCollectorTaskArg, Iterable<? extends VisorGridEvent>, Collection<? extends VisorGridEvent>> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeEventsCollectorJob job(VisorNodeEventsCollectorTaskArg arg) {
        return new VisorNodeEventsCollectorJob(arg, this.debug);
    }

    @Override
    protected Iterable<? extends VisorGridEvent> reduce0(List<ComputeJobResult> results) {
        ArrayList allEvts = new ArrayList();
        for (ComputeJobResult r : results) {
            if (r.getException() != null) continue;
            allEvts.addAll((Collection)r.getData());
        }
        return allEvts.isEmpty() ? Collections.emptyList() : allEvts;
    }

    protected static class VisorNodeEventsCollectorJob
    extends VisorJob<VisorNodeEventsCollectorTaskArg, Collection<? extends VisorGridEvent>> {
        private static final long serialVersionUID = 0L;

        protected VisorNodeEventsCollectorJob(VisorNodeEventsCollectorTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private boolean containsInTaskName(String taskName, String taskClsName, String s2) {
            assert (taskName != null);
            assert (taskClsName != null);
            if (taskName.equals(taskClsName)) {
                int idx = taskName.lastIndexOf(46);
                return (idx >= 0 ? taskName.substring(idx + 1) : taskName).toLowerCase().contains(s2);
            }
            return taskName.toLowerCase().contains(s2);
        }

        private boolean filterByTaskName(Event e, String taskName) {
            String compareTaskName = taskName.toLowerCase();
            if (e.getClass().equals(TaskEvent.class)) {
                TaskEvent te = (TaskEvent)e;
                return this.containsInTaskName(te.taskName(), te.taskClassName(), compareTaskName);
            }
            if (e.getClass().equals(JobEvent.class)) {
                JobEvent je = (JobEvent)e;
                return this.containsInTaskName(je.taskName(), je.taskName(), compareTaskName);
            }
            if (e.getClass().equals(DeploymentEvent.class)) {
                DeploymentEvent de = (DeploymentEvent)e;
                return de.alias().toLowerCase().contains(compareTaskName);
            }
            return true;
        }

        private boolean filterByTaskSessionId(Event e, IgniteUuid taskSesId) {
            if (e.getClass().equals(TaskEvent.class)) {
                TaskEvent te = (TaskEvent)e;
                return te.taskSessionId().equals(taskSesId);
            }
            if (e.getClass().equals(JobEvent.class)) {
                JobEvent je = (JobEvent)e;
                return je.taskSessionId().equals(taskSesId);
            }
            return true;
        }

        protected VisorEventMapper eventMapper() {
            return VisorTaskUtils.EVT_MAPPER;
        }

        @Override
        protected Collection<? extends VisorGridEvent> run(final VisorNodeEventsCollectorTaskArg arg) {
            final long startEvtTime = arg.getTimeArgument() == null ? 0L : System.currentTimeMillis() - arg.getTimeArgument();
            ConcurrentMap<String, Long> nl = this.ignite.cluster().nodeLocalMap();
            final Long startEvtOrder = arg.getKeyOrder() != null && nl.containsKey(arg.getKeyOrder()) ? (Long)nl.get(arg.getKeyOrder()) : Long.valueOf(-1L);
            Collection<Event> evts = this.ignite.events().localQuery(new IgnitePredicate<Event>(){
                private static final long serialVersionUID = 0L;

                @Override
                public boolean apply(Event evt) {
                    return !(evt.localOrder() <= startEvtOrder || arg.getTypeArgument() != null && !F.contains(arg.getTypeArgument(), evt.type()) || evt.timestamp() < startEvtTime || arg.getTaskName() != null && !this.filterByTaskName(evt, arg.getTaskName()) || arg.getTaskSessionId() != null && !this.filterByTaskSessionId(evt, arg.getTaskSessionId()));
                }
            }, new int[0]);
            ArrayList<VisorGridEvent> res = new ArrayList<VisorGridEvent>(evts.size());
            Long maxOrder = startEvtOrder;
            VisorEventMapper mapper = this.eventMapper();
            for (Event e : evts) {
                maxOrder = Math.max(maxOrder, e.localOrder());
                VisorGridEvent visorEvt = (VisorGridEvent)mapper.apply(e);
                if (visorEvt != null) {
                    res.add(visorEvt);
                    continue;
                }
                res.add(new VisorGridEvent(e.type(), e.id(), e.name(), e.node().id(), e.timestamp(), e.message(), e.shortDisplay()));
            }
            if (arg.getKeyOrder() != null && !res.isEmpty()) {
                nl.put(arg.getKeyOrder(), maxOrder);
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorNodeEventsCollectorJob.class, this);
        }
    }
}

