/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;

public class VisorComputeMonitoringHolder {
    private static final String COMPUTE_MONITORING_HOLDER_KEY = "VISOR_COMPUTE_MONITORING_KEY";
    private final Map<String, EventsSession> listeners = new HashMap<String, EventsSession>();
    private boolean cleanupScheduled = true;
    private static final int CLEANUP_TIMEOUT = 120000;

    public static VisorComputeMonitoringHolder getInstance(IgniteEx ignite) {
        ConcurrentMap<String, VisorComputeMonitoringHolder> storage = ignite.cluster().nodeLocalMap();
        VisorComputeMonitoringHolder holder = (VisorComputeMonitoringHolder)storage.get(COMPUTE_MONITORING_HOLDER_KEY);
        if (holder == null) {
            holder = new VisorComputeMonitoringHolder();
            VisorComputeMonitoringHolder holderOld = storage.putIfAbsent(COMPUTE_MONITORING_HOLDER_KEY, holder);
            return holderOld == null ? holder : holderOld;
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCollect(IgniteEx ignite, String visorKey, int[] types) {
        Map<String, EventsSession> map = this.listeners;
        synchronized (map) {
            if (this.cleanupScheduled) {
                this.scheduleCleanupJob(ignite);
            }
            this.listeners.compute(visorKey, (k, v) -> {
                if (v == null) {
                    return new EventsSession(types);
                }
                v.addEvents(types);
                return v;
            });
            ignite.events().enableLocal(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCollect(IgniteEx ignite, String visorKey) {
        Map<String, EventsSession> map = this.listeners;
        synchronized (map) {
            EventsSession ses = this.listeners.remove(visorKey);
            if (ses != null) {
                this.tryDisableEvents(ignite, ses.types());
            }
        }
    }

    public String toString() {
        return S.toString(VisorComputeMonitoringHolder.class, this);
    }

    private void tryDisableEvents(IgniteEx ignite, Set<Integer> expiredEvts) {
        Set activeEvts = this.listeners.values().stream().flatMap(s2 -> ((EventsSession)s2).types.stream()).collect(Collectors.toSet());
        expiredEvts.removeAll(activeEvts);
        if (!expiredEvts.isEmpty()) {
            int[] types = expiredEvts.stream().mapToInt(Integer::intValue).toArray();
            ignite.events().disableLocal(types);
        }
    }

    private void removeExpired(IgniteEx ignite) {
        Set expiredSes = this.listeners.values().stream().filter(EventsSession::isExpired).collect(Collectors.toSet());
        if (expiredSes.isEmpty()) {
            return;
        }
        this.listeners.values().removeAll(expiredSes);
        Set<Integer> expiredEvts = expiredSes.stream().flatMap(s2 -> ((EventsSession)s2).types.stream()).collect(Collectors.toSet());
        this.tryDisableEvents(ignite, expiredEvts);
    }

    private void scheduleCleanupJob(final IgniteEx ignite) {
        this.cleanupScheduled = ignite.context().timeout().addTimeoutObject(new GridTimeoutObjectAdapter(120000L){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeout() {
                Map map = VisorComputeMonitoringHolder.this.listeners;
                synchronized (map) {
                    VisorComputeMonitoringHolder.this.removeExpired(ignite);
                    for (EventsSession v : VisorComputeMonitoringHolder.this.listeners.values()) {
                        v.markExpired();
                    }
                    if (VisorComputeMonitoringHolder.this.listeners.isEmpty()) {
                        VisorComputeMonitoringHolder.this.cleanupScheduled = false;
                    } else {
                        VisorComputeMonitoringHolder.this.scheduleCleanupJob(ignite);
                    }
                }
            }
        });
    }

    private static final class EventsSession {
        private boolean expired = true;
        private Set<Integer> types;

        EventsSession(int[] types) {
            this.types = Arrays.stream(types).boxed().collect(Collectors.toSet());
        }

        boolean isExpired() {
            return this.expired;
        }

        Set<Integer> types() {
            return this.types;
        }

        void addEvents(int[] types) {
            for (int type : types) {
                this.types.add(type);
            }
            this.expired = false;
        }

        void markExpired() {
            this.expired = false;
        }
    }
}

