/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;

public class GridFinishedFuture<T>
implements IgniteInternalFuture<T> {
    private static final byte ERR = 1;
    private static final byte RES = 2;
    private final byte resFlag;
    private final Object res;

    public GridFinishedFuture() {
        this.res = null;
        this.resFlag = (byte)2;
    }

    public GridFinishedFuture(T t2) {
        this.res = t2;
        this.resFlag = (byte)2;
    }

    public GridFinishedFuture(Throwable err) {
        this.res = err;
        this.resFlag = 1;
    }

    @Override
    public Throwable error() {
        return this.resFlag == 1 ? (Throwable)this.res : null;
    }

    @Override
    public T result() {
        return (T)(this.resFlag == 2 ? this.res : null);
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() throws IgniteCheckedException {
        if (this.resFlag == 1) {
            throw U.cast((Throwable)this.res);
        }
        return (T)this.res;
    }

    @Override
    public T get(long timeout) throws IgniteCheckedException {
        return this.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws IgniteCheckedException {
        return this.get();
    }

    @Override
    public T getUninterruptibly() throws IgniteCheckedException {
        return this.get();
    }

    @Override
    public void listen(IgniteInClosure<? super IgniteInternalFuture<T>> lsnr) {
        assert (lsnr != null);
        lsnr.apply(this);
    }

    @Override
    public <R> IgniteInternalFuture<R> chain(IgniteClosure<? super IgniteInternalFuture<T>, R> doneCb) {
        try {
            return new GridFinishedFuture<R>(doneCb.apply(this));
        }
        catch (GridClosureException e) {
            return new GridFinishedFuture<T>(e.unwrap());
        }
        catch (Error | RuntimeException e) {
            return new GridFinishedFuture<T>(e);
        }
    }

    @Override
    public <T1> IgniteInternalFuture<T1> chain(final IgniteClosure<? super IgniteInternalFuture<T>, T1> doneCb, Executor exec) {
        final GridFutureAdapter fut = new GridFutureAdapter();
        exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    fut.onDone(doneCb.apply(GridFinishedFuture.this));
                }
                catch (GridClosureException e) {
                    fut.onDone(e.unwrap());
                }
                catch (Error | RuntimeException e) {
                    fut.onDone(e);
                    throw e;
                }
            }
        });
        return fut;
    }

    @Override
    public <R> IgniteInternalFuture<R> chainCompose(IgniteClosure<? super IgniteInternalFuture<T>, IgniteInternalFuture<R>> doneCb) {
        try {
            return doneCb.apply(this);
        }
        catch (GridClosureException e) {
            return new GridFinishedFuture<T>(e.unwrap());
        }
        catch (Error | RuntimeException e) {
            return new GridFinishedFuture<T>(e);
        }
    }

    @Override
    public <R> IgniteInternalFuture<R> chainCompose(IgniteClosure<? super IgniteInternalFuture<T>, IgniteInternalFuture<R>> doneCb, Executor exec) {
        GridFutureAdapter res = new GridFutureAdapter();
        exec.execute(() -> {
            GridFinishedFuture<T> doneCbFut;
            try {
                doneCbFut = (GridFinishedFuture<T>)doneCb.apply(this);
            }
            catch (GridClosureException e) {
                doneCbFut = new GridFinishedFuture<T>(e.unwrap());
            }
            catch (RuntimeException e) {
                doneCbFut = new GridFinishedFuture<T>(e);
            }
            doneCbFut.listen((? super IgniteInternalFuture<R> f) -> {
                try {
                    res.onDone(f.get(), null);
                }
                catch (Exception e) {
                    res.onDone(e);
                }
            });
        });
        return res;
    }

    public String toString() {
        return S.toString(GridFinishedFuture.class, this);
    }
}

