/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridLogThrottle {
    public static final int DFLT_THROTTLE_TIMEOUT = 300000;
    private static volatile int throttleTimeout = 300000;
    public static final int DFLT_LOG_THROTTLE_CAPACITY = 128;
    private static final int throttleCap = IgniteSystemProperties.getInteger("IGNITE_LOG_THROTTLE_CAPACITY", 128);
    private static volatile ConcurrentMap<IgniteBiTuple<Class<? extends Throwable>, String>, Long> msgs = new ConcurrentLinkedHashMap<IgniteBiTuple<Class<? extends Throwable>, String>, Long>(throttleCap, 0.75f, 16, throttleCap);

    public static void throttleTimeout(int timeout) {
        throttleTimeout = timeout;
    }

    public static int throttleTimeout() {
        return throttleTimeout;
    }

    public static int throttleCapacity() {
        return throttleCap;
    }

    public static void error(@Nullable IgniteLogger log, @Nullable Throwable e, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, msg, LogLevel.ERROR, false, false);
    }

    public static void error(@Nullable IgniteLogger log, @Nullable Throwable e, String throttleKey, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, throttleKey, msg, LogLevel.ERROR, false, false);
    }

    public static void error(@Nullable IgniteLogger log, @Nullable Throwable e, String msg, boolean byMsg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, msg, LogLevel.ERROR, false, byMsg);
    }

    public static void warn(@Nullable IgniteLogger log, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, msg, msg, LogLevel.WARN, false, false);
    }

    public static void warn(@Nullable IgniteLogger log, String throttleKey, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, throttleKey, msg, LogLevel.WARN, false, false);
    }

    public static void warn(@Nullable IgniteLogger log, @Nullable Throwable e, String msg, boolean quite, boolean byMsg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, msg, LogLevel.WARN, quite, byMsg);
    }

    public static void warn(@Nullable IgniteLogger log, String msg, boolean quiet) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, msg, msg, LogLevel.WARN, quiet, false);
    }

    public static void warn(@Nullable IgniteLogger log, String msg, Throwable e) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, msg, LogLevel.WARN, false, false);
    }

    public static void info(@Nullable IgniteLogger log, String msg, boolean quiet) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, msg, msg, LogLevel.INFO, quiet, false);
    }

    public static void info(@Nullable IgniteLogger log, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.info(log, msg, false);
    }

    public static void info(@Nullable IgniteLogger log, String throttleKey, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, throttleKey, msg, LogLevel.INFO, false, false);
    }

    public static void clear() {
        msgs = new ConcurrentLinkedHashMap<IgniteBiTuple<Class<? extends Throwable>, String>, Long>(throttleCap, 0.75f, 16, throttleCap);
    }

    private static void log(@Nullable IgniteLogger log, @Nullable Throwable e, String throttleKey, String longMsg, LogLevel level, boolean quiet, boolean byMsg) {
        block2: {
            long curTs;
            Long loggedTs;
            assert (!F.isEmpty(longMsg));
            IgniteBiTuple<Object, String> msgKey = e != null && !byMsg ? F.t(e.getClass(), e.getMessage()) : F.t(null, throttleKey);
            do {
                loggedTs = (Long)msgs.get(msgKey);
                curTs = U.currentTimeMillis();
                if (loggedTs != null && loggedTs >= curTs - (long)throttleTimeout) break block2;
            } while (!GridLogThrottle.replace(msgKey, loggedTs, curTs));
            level.doLog(log, longMsg, e, quiet);
        }
    }

    private static boolean replace(IgniteBiTuple<Class<? extends Throwable>, String> t2, @Nullable Long oldStamp, Long newStamp) {
        assert (newStamp != null);
        if (oldStamp == null) {
            Long old = msgs.putIfAbsent(t2, newStamp);
            return old == null;
        }
        return msgs.replace(t2, oldStamp, newStamp);
    }

    protected GridLogThrottle() {
    }

    private static enum LogLevel {
        ERROR{

            @Override
            public void doLog(IgniteLogger log, String msg, Throwable e, boolean quiet) {
                if (e != null) {
                    U.error(log, msg, e);
                } else {
                    U.error(log, msg);
                }
            }
        }
        ,
        WARN{

            @Override
            public void doLog(IgniteLogger log, String msg, Throwable e, boolean quiet) {
                if (quiet) {
                    U.quietAndWarn(log, (Object)msg, e);
                } else {
                    U.warn(log, msg, e);
                }
            }
        }
        ,
        INFO{

            @Override
            public void doLog(IgniteLogger log, String msg, Throwable e, boolean quiet) {
                if (quiet) {
                    U.quietAndInfo(log, msg);
                } else if (log.isInfoEnabled()) {
                    log.info(msg);
                }
            }
        };


        public abstract void doLog(IgniteLogger var1, String var2, Throwable var3, boolean var4);
    }
}

