/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.suggestions;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class JvmConfigurationSuggestions {
    private static final String XMX = "-Xmx";
    private static final String MX = "-mx";
    private static final String MAX_DIRECT_MEMORY_SIZE = "-XX:MaxDirectMemorySize";
    private static final String DISABLE_EXPLICIT_GC = "-XX:+DisableExplicitGC";
    private static final String NOT_USE_TLAB = "-XX:-UseTLAB";
    private static final String SERVER = "-server";
    private static final String USE_G1_GC = "-XX:+UseG1GC";

    public static synchronized List<String> getSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        List<String> args = U.jvmArgs();
        if (!U.jvmName().toLowerCase().contains("server")) {
            suggestions.add("Enable server mode for JVM (add '-server' to JVM options)");
        }
        if (!"11".equals(U.jdkVersion())) {
            suggestions.add("Switch to the most recent 11 JVM version");
        }
        if (U.jdkVersion().equals("1.8") && !args.contains(USE_G1_GC)) {
            suggestions.add("Enable G1 Garbage Collector (add '-XX:+UseG1GC' to JVM options)");
        }
        if (!JvmConfigurationSuggestions.anyStartWith(args, XMX) && !JvmConfigurationSuggestions.anyStartWith(args, MX)) {
            suggestions.add("Specify JVM heap max size (add '-Xmx<size>[g|G|m|M|k|K]' to JVM options)");
        }
        if (!JvmConfigurationSuggestions.anyStartWith(args, MAX_DIRECT_MEMORY_SIZE)) {
            suggestions.add("Set max direct memory size if getting 'OOME: Direct buffer memory' (add '-XX:MaxDirectMemorySize=<size>[g|G|m|M|k|K]' to JVM options)");
        }
        if (args.contains(NOT_USE_TLAB)) {
            suggestions.add("Enable thread-local allocation buffer (add '-XX:+UseTLAB' to JVM options)");
        }
        return suggestions;
    }

    public static void warnIfExplicitGcDisabled(IgniteLogger log) {
        List<String> args = U.jvmArgs();
        if (JvmConfigurationSuggestions.anyStartWith(args, DISABLE_EXPLICIT_GC)) {
            U.error(log, "-XX:+DisableExplicitGC usage detected. We strongly recommend you to remove this flag from JVM arguments, since it can impact direct byte buffers memory cleanup and be a reason of errors like 'java.lang.OutOfMemoryError: Direct buffer memory'");
        }
    }

    private static boolean anyStartWith(@NotNull List<String> lines, @NotNull String prefix) {
        for (String line : lines) {
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return S.toString(JvmConfigurationSuggestions.class, this);
    }
}

