/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.stat;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderCache;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.stat.IoStatisticsHolderKey;

public class IoStatisticsManager {
    private final Map<IoStatisticsType, Map<IoStatisticsHolderKey, IoStatisticsHolder>> statByType = new EnumMap<IoStatisticsType, Map<IoStatisticsHolderKey, IoStatisticsHolder>>(IoStatisticsType.class);
    private volatile OffsetDateTime startTime;

    public IoStatisticsManager() {
        for (IoStatisticsType types : IoStatisticsType.values()) {
            this.statByType.put(types, new ConcurrentHashMap());
        }
        this.reset();
    }

    public IoStatisticsHolder onCacheGroupRegistered(String name, int grpId, IoStatisticsHolderCache statCache) {
        return this.register(new IoStatisticsHolderKey(name), IoStatisticsType.CACHE_GROUP, statCache);
    }

    public IoStatisticsHolder onIndexRegistered(IoStatisticsType type, String name, String idxName, IoStatisticsHolderIndex statIdx) {
        assert (type == IoStatisticsType.HASH_INDEX || type == IoStatisticsType.SORTED_INDEX) : type;
        return this.register(new IoStatisticsHolderKey(name, idxName), type, statIdx);
    }

    private IoStatisticsHolder register(IoStatisticsHolderKey statKey, IoStatisticsType type, IoStatisticsHolder stat) {
        if (this.statByType.isEmpty()) {
            throw new IgniteIllegalStateException("IO Statistics manager has been stopped and can'be used");
        }
        IoStatisticsHolder existedStatisitcHolder = this.statByType.get((Object)type).put(statKey, stat);
        return existedStatisitcHolder != null ? existedStatisitcHolder : stat;
    }

    public void stop() {
        this.statByType.clear();
    }

    public void reset() {
        this.statByType.forEach((t2, s2) -> s2.forEach((k, sh) -> sh.resetStatistics()));
        this.startTime = OffsetDateTime.now();
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public Set<String> deriveStatisticNames(IoStatisticsType statType) {
        assert (statType != null);
        return this.statByType.get((Object)statType).keySet().stream().map(IoStatisticsHolderKey::name).collect(Collectors.toSet());
    }

    public Set<String> deriveStatisticSubNames(IoStatisticsType statType, String name) {
        assert (statType != null);
        return this.statByType.get((Object)statType).keySet().stream().filter(k -> k.name().equalsIgnoreCase(name) && k.subName() != null).map(IoStatisticsHolderKey::subName).collect(Collectors.toSet());
    }

    public Map<String, Long> physicalReadsMap(IoStatisticsType statType, String name, String subName) {
        IoStatisticsHolder statHolder = this.statByType.get((Object)statType).get(new IoStatisticsHolderKey(name, subName));
        return statHolder != null ? statHolder.physicalReadsMap() : Collections.emptyMap();
    }

    public Long physicalReads(IoStatisticsType statType, String name, String subName) {
        IoStatisticsHolder statHolder = this.statByType.get((Object)statType).get(new IoStatisticsHolderKey(name, subName));
        return statHolder != null ? Long.valueOf(statHolder.physicalReads()) : null;
    }

    public Map<String, Long> logicalReadsMap(IoStatisticsType statType, String name, String subName) {
        IoStatisticsHolder statHolder = this.statByType.get((Object)statType).get(new IoStatisticsHolderKey(name, subName));
        return statHolder != null ? statHolder.logicalReadsMap() : Collections.emptyMap();
    }

    public Long logicalReads(IoStatisticsType statType, String name, String subName) {
        IoStatisticsHolder stat = this.statByType.get((Object)statType).get(new IoStatisticsHolderKey(name, subName));
        return stat != null ? Long.valueOf(stat.logicalReads()) : null;
    }

    public Map<IoStatisticsHolderKey, IoStatisticsHolder> statistics(IoStatisticsType statType) {
        return Collections.unmodifiableMap(this.statByType.get((Object)statType));
    }
}

