/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.ssl;

import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.ignite.internal.ssl.SSLContextSpiWrapper;

public class SSLContextParametersWrapper
extends SSLContext {
    public SSLContextParametersWrapper(SSLContext delegate, SSLParameters sslParameters) {
        super(new SSLContextParametersSpiWrapper(delegate, sslParameters), delegate.getProvider(), delegate.getProtocol());
    }

    private static class SSLContextParametersSpiWrapper
    extends SSLContextSpiWrapper {
        private final SSLParameters sslParameters;

        SSLContextParametersSpiWrapper(SSLContext sslContextDelegate, SSLParameters sslParameters) {
            super(sslContextDelegate);
            this.sslParameters = sslParameters;
        }

        @Override
        protected void configureSSLEngine(SSLEngine engine) {
            if (this.sslParameters != null) {
                engine.setSSLParameters(this.sslParameters);
            }
        }

        @Override
        protected void configureSocket(Socket socket) {
            if (this.sslParameters != null) {
                ((SSLSocket)socket).setSSLParameters(this.sslParameters);
            }
        }

        @Override
        protected void configureServerSocket(ServerSocket socket) {
            if (this.sslParameters != null) {
                ((SSLServerSocket)socket).setSSLParameters(this.sslParameters);
            }
        }
    }
}

