/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueDecimal;

public class GridH2Decimal
extends GridH2ValueMessage {
    private int scale;
    private byte[] b;

    public GridH2Decimal() {
    }

    public GridH2Decimal(Value val) {
        assert (val.getType().getValueType() == 6) : val.getType();
        BigDecimal x = val.getBigDecimal();
        this.scale = x.scale();
        this.b = x.unscaledValue().toByteArray();
    }

    @Override
    public Value value(GridKernalContext ctx) {
        return ValueDecimal.get(new BigDecimal(new BigInteger(this.b), this.scale));
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("b", this.b)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("scale", this.scale)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.b = reader.readByteArray("b");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.scale = reader.readInt("scale");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2Decimal.class);
    }

    @Override
    public short directType() {
        return -10;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return this.scale + "_" + StringUtils.convertBytesToHex(this.b);
    }
}

