/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryFetchSizeInterceptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.MapH2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.jdbc.JdbcResultSet;
import org.gridgain.internal.h2.result.LazyResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapQueryResult {
    private static final Field RESULT_FIELD;
    private final IgniteH2Indexing h2;
    private final GridCacheContext<?, ?> cctx;
    private final GridCacheSqlQuery qry;
    private final UUID qrySrcNodeId;
    private volatile Result res;
    private final IgniteLogger log;
    private final Object[] params;
    private int page;
    private boolean cpNeeded;
    private volatile boolean closed;
    private final Session ses;
    private H2PooledConnection conn;
    private final ReentrantLock lock = new ReentrantLock();

    MapQueryResult(IgniteH2Indexing h2, @Nullable GridCacheContext cctx, UUID qrySrcNodeId, GridCacheSqlQuery qry, Object[] params, H2PooledConnection conn, IgniteLogger log) {
        this.h2 = h2;
        this.cctx = cctx;
        this.qry = qry;
        this.params = params;
        this.qrySrcNodeId = qrySrcNodeId;
        this.cpNeeded = F.eq(h2.kernalContext().localNodeId(), qrySrcNodeId);
        this.log = log;
        this.conn = conn;
        this.ses = H2Utils.session(conn.connection());
    }

    void openResult(@NotNull ResultSet rs, MapH2QueryInfo qryInfo, Tracing tracing) {
        this.res = new Result(rs, qryInfo, tracing);
    }

    int page() {
        return this.page;
    }

    int rowCount() {
        assert (this.res != null);
        return this.res.rowCnt;
    }

    int columnCount() {
        assert (this.res != null);
        return this.res.cols;
    }

    boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetchNextPage(List<Value[]> rows, int pageSize, Boolean dataPageScanEnabled) {
        assert (this.lock.isHeldByCurrentThread());
        if (this.closed) {
            return true;
        }
        assert (this.res != null);
        boolean readEvt = this.cctx != null && this.cctx.name() != null && this.cctx.events().isRecordable(97);
        ++this.page;
        this.h2.enableDataPageScan(dataPageScanEnabled);
        try {
            for (int i = 0; i < pageSize; ++i) {
                if (!this.res.res.next()) {
                    boolean bl = true;
                    return bl;
                }
                Value[] row = MapQueryResult.convertIntervalTypes(this.res.res.currentRow());
                if (this.cpNeeded) {
                    boolean copied = false;
                    for (int j = 0; j < row.length; ++j) {
                        Value val = row[j];
                        if (!(val instanceof GridH2ValueCacheObject)) continue;
                        GridH2ValueCacheObject valCacheObj = (GridH2ValueCacheObject)val;
                        row[j] = new GridH2ValueCacheObject(valCacheObj.getCacheObject(), this.h2.objectContext()){

                            @Override
                            public Object getObject() {
                                return this.getObject(true);
                            }
                        };
                        copied = true;
                    }
                    if (i == 0 && !copied) {
                        this.cpNeeded = false;
                    }
                }
                assert (row != null);
                if (readEvt) {
                    GridKernalContext ctx = this.h2.kernalContext();
                    ctx.event().record(new CacheQueryReadEvent<Object, Object>(ctx.discovery().localNode(), "SQL fields query result set row read.", 97, CacheQueryType.SQL.name(), this.cctx.name(), null, this.qry.query(), null, null, this.params, this.qrySrcNodeId, null, null, null, null, this.row(row)));
                }
                rows.add(row);
                this.res.fetchSizeInterceptor.checkOnFetchNext();
            }
            boolean bl = !this.res.res.hasNext();
            return bl;
        }
        finally {
            CacheDataTree.setDataPageScanEnabled(false);
        }
    }

    private List<?> row(Value[] row) {
        ArrayList<Object> res = new ArrayList<Object>(row.length);
        for (Value v : row) {
            res.add(v.getObject());
        }
        return res;
    }

    private static Value[] convertIntervalTypes(Value[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (!DataType.isIntervalType(row[i].getValueType())) continue;
            row[i] = row[i].convertTo(5);
        }
        return row;
    }

    void close() {
        assert (this.lock.isHeldByCurrentThread());
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.res != null) {
            this.res.close();
        }
        this.ses.setQueryContext(null);
        H2MemoryTracker tracker = this.ses.memoryTracker();
        if (tracker != null) {
            tracker.close();
        }
        this.conn.close();
    }

    public void lock() {
        if (!this.lock.isHeldByCurrentThread()) {
            this.lock.lock();
        }
    }

    public void lockTables() {
        if (!this.closed && this.ses.isLazyQueryExecution()) {
            GridH2Table.readLockTables(this.ses);
        }
    }

    public void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public void unlockTables() {
        if (!this.closed && this.ses.isLazyQueryExecution()) {
            GridH2Table.unlockTables(this.ses);
        }
    }

    public void checkTablesVersions() {
        if (this.ses.isLazyQueryExecution()) {
            GridH2Table.checkTablesVersions(this.ses);
        }
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private class Result {
        private final ResultInterface res;
        private final ResultSet rs;
        private final int cols;
        private final int rowCnt;
        private final H2QueryFetchSizeInterceptor fetchSizeInterceptor;
        private final Tracing tracing;

        Result(ResultSet rs, MapH2QueryInfo qryInfo, Tracing tracing) {
            this.rs = rs;
            this.tracing = tracing;
            try {
                this.res = (ResultInterface)RESULT_FIELD.get(rs);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            this.rowCnt = this.res instanceof LazyResult ? -1 : this.res.getRowCount();
            this.cols = this.res.getVisibleColumnCount();
            this.fetchSizeInterceptor = new H2QueryFetchSizeInterceptor(MapQueryResult.this.h2, qryInfo, MapQueryResult.this.log);
        }

        private String planOrSql() {
            try {
                Prepared stmt = GridSqlQueryParser.prepared((PreparedStatement)this.rs.getStatement());
                String plan = stmt.getPlanSQL(false);
                return plan != null ? plan : stmt.getSQL().replace('\n', ' ').replace("\"", "");
            }
            catch (SQLException ex) {
                MapQueryResult.this.log.error("Unexpected exception", ex);
                return "Error on fetch plan: " + ex.getMessage();
            }
        }

        void close() {
            try (MTC.TraceSurroundings ignored = MTC.support(this.tracing.create(SpanType.SQL_QRY_MAP_END, MTC.span()).addLog(this::planOrSql));){
                this.fetchSizeInterceptor.checkOnClose();
                U.close(this.rs, MapQueryResult.this.log);
            }
        }
    }
}

