/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class SqlSystemViewCaches
extends SqlAbstractLocalSystemView {
    public SqlSystemViewCaches(GridKernalContext ctx) {
        super("CACHES", "Ignite caches", ctx, "CACHE_NAME", SqlSystemViewCaches.newColumn("CACHE_GROUP_ID", 4), SqlSystemViewCaches.newColumn("CACHE_GROUP_NAME"), SqlSystemViewCaches.newColumn("CACHE_ID", 4), SqlSystemViewCaches.newColumn("CACHE_NAME"), SqlSystemViewCaches.newColumn("CACHE_TYPE"), SqlSystemViewCaches.newColumn("CACHE_MODE"), SqlSystemViewCaches.newColumn("ATOMICITY_MODE"), SqlSystemViewCaches.newColumn("IS_ONHEAP_CACHE_ENABLED", 1), SqlSystemViewCaches.newColumn("IS_COPY_ON_READ", 1), SqlSystemViewCaches.newColumn("IS_LOAD_PREVIOUS_VALUE", 1), SqlSystemViewCaches.newColumn("IS_READ_FROM_BACKUP", 1), SqlSystemViewCaches.newColumn("PARTITION_LOSS_POLICY"), SqlSystemViewCaches.newColumn("NODE_FILTER"), SqlSystemViewCaches.newColumn("TOPOLOGY_VALIDATOR"), SqlSystemViewCaches.newColumn("IS_EAGER_TTL", 1), SqlSystemViewCaches.newColumn("WRITE_SYNCHRONIZATION_MODE"), SqlSystemViewCaches.newColumn("IS_INVALIDATE", 1), SqlSystemViewCaches.newColumn("IS_EVENTS_DISABLED", 1), SqlSystemViewCaches.newColumn("IS_STATISTICS_ENABLED", 1), SqlSystemViewCaches.newColumn("IS_MANAGEMENT_ENABLED", 1), SqlSystemViewCaches.newColumn("BACKUPS", 4), SqlSystemViewCaches.newColumn("AFFINITY"), SqlSystemViewCaches.newColumn("AFFINITY_MAPPER"), SqlSystemViewCaches.newColumn("REBALANCE_MODE"), SqlSystemViewCaches.newColumn("REBALANCE_BATCH_SIZE", 4), SqlSystemViewCaches.newColumn("REBALANCE_TIMEOUT", 5), SqlSystemViewCaches.newColumn("REBALANCE_DELAY", 5), SqlSystemViewCaches.newColumn("REBALANCE_THROTTLE", 5), SqlSystemViewCaches.newColumn("REBALANCE_BATCHES_PREFETCH_COUNT", 5), SqlSystemViewCaches.newColumn("REBALANCE_ORDER", 4), SqlSystemViewCaches.newColumn("EVICTION_FILTER"), SqlSystemViewCaches.newColumn("EVICTION_POLICY_FACTORY"), SqlSystemViewCaches.newColumn("IS_NEAR_CACHE_ENABLED", 1), SqlSystemViewCaches.newColumn("NEAR_CACHE_EVICTION_POLICY_FACTORY"), SqlSystemViewCaches.newColumn("NEAR_CACHE_START_SIZE", 4), SqlSystemViewCaches.newColumn("DEFAULT_LOCK_TIMEOUT", 5), SqlSystemViewCaches.newColumn("CACHE_INTERCEPTOR"), SqlSystemViewCaches.newColumn("CACHE_STORE_FACTORY"), SqlSystemViewCaches.newColumn("IS_STORE_KEEP_BINARY", 1), SqlSystemViewCaches.newColumn("IS_READ_THROUGH", 1), SqlSystemViewCaches.newColumn("IS_WRITE_THROUGH", 1), SqlSystemViewCaches.newColumn("IS_WRITE_BEHIND_ENABLED", 1), SqlSystemViewCaches.newColumn("WRITE_BEHIND_COALESCING", 1), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_SIZE", 4), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_FREQUENCY", 5), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_THREAD_COUNT", 4), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_BATCH_SIZE", 4), SqlSystemViewCaches.newColumn("MAX_CONCURRENT_ASYNC_OPERATIONS", 4), SqlSystemViewCaches.newColumn("CACHE_LOADER_FACTORY"), SqlSystemViewCaches.newColumn("CACHE_WRITER_FACTORY"), SqlSystemViewCaches.newColumn("EXPIRY_POLICY_FACTORY"), SqlSystemViewCaches.newColumn("IS_SQL_ESCAPE_ALL", 1), SqlSystemViewCaches.newColumn("SQL_SCHEMA"), SqlSystemViewCaches.newColumn("SQL_INDEX_MAX_INLINE_SIZE", 4), SqlSystemViewCaches.newColumn("IS_SQL_ONHEAP_CACHE_ENABLED", 1), SqlSystemViewCaches.newColumn("SQL_ONHEAP_CACHE_MAX_SIZE", 4), SqlSystemViewCaches.newColumn("QUERY_DETAILS_METRICS_SIZE", 4), SqlSystemViewCaches.newColumn("QUERY_PARALLELISM", 4), SqlSystemViewCaches.newColumn("MAX_QUERY_ITERATORS_COUNT", 4), SqlSystemViewCaches.newColumn("DATA_REGION_NAME"));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        DynamicCacheDescriptor cache2;
        SqlSystemViewColumnCondition nameCond = this.conditionForColumn("CACHE_NAME", first, last);
        Collection<Object> caches = nameCond.isEquality() ? ((cache2 = this.ctx.cache().cacheDescriptor(nameCond.valueForEquality().getString())) == null ? Collections.emptySet() : Collections.singleton(cache2)) : this.ctx.cache().cacheDescriptors().values();
        return F.iterator(caches, cache -> {
            CacheConfiguration ccfg = cache.cacheConfiguration();
            return this.createRow(ses, new Object[]{cache.groupId(), cache.groupDescriptor().cacheOrGroupName(), cache.cacheId(), cache.cacheName(), cache.cacheType(), ccfg.getCacheMode(), ccfg.getAtomicityMode(), ccfg.isOnheapCacheEnabled(), ccfg.isCopyOnRead(), ccfg.isLoadPreviousValue(), ccfg.isReadFromBackup(), ccfg.getPartitionLossPolicy(), SqlSystemViewCaches.nodeFilter(ccfg), SqlSystemViewCaches.toStringSafe(ccfg.getTopologyValidator()), ccfg.isEagerTtl(), ccfg.getWriteSynchronizationMode(), ccfg.isInvalidate(), ccfg.isEventsDisabled(), ccfg.isStatisticsEnabled(), ccfg.isManagementEnabled(), ccfg.getCacheMode() == CacheMode.REPLICATED ? null : Integer.valueOf(ccfg.getBackups()), SqlSystemViewCaches.toStringSafe(ccfg.getAffinity()), SqlSystemViewCaches.toStringSafe(ccfg.getAffinityMapper()), ccfg.getRebalanceMode(), ccfg.getRebalanceBatchSize(), ccfg.getRebalanceTimeout(), ccfg.getRebalanceDelay(), ccfg.getRebalanceThrottle(), ccfg.getRebalanceBatchesPrefetchCount(), ccfg.getRebalanceOrder(), SqlSystemViewCaches.toStringSafe(ccfg.getEvictionFilter()), SqlSystemViewCaches.toStringSafe(ccfg.getEvictionPolicyFactory()), ccfg.getNearConfiguration() != null, ccfg.getNearConfiguration() != null ? SqlSystemViewCaches.toStringSafe(ccfg.getNearConfiguration().getNearEvictionPolicyFactory()) : null, ccfg.getNearConfiguration() != null ? Integer.valueOf(ccfg.getNearConfiguration().getNearStartSize()) : null, ccfg.getDefaultLockTimeout(), SqlSystemViewCaches.toStringSafe(ccfg.getInterceptor()), SqlSystemViewCaches.toStringSafe(ccfg.getCacheStoreFactory()), ccfg.isStoreKeepBinary(), ccfg.isReadThrough(), ccfg.isWriteThrough(), ccfg.isWriteBehindEnabled(), ccfg.getWriteBehindCoalescing(), ccfg.getWriteBehindFlushSize(), ccfg.getWriteBehindFlushFrequency(), ccfg.getWriteBehindFlushThreadCount(), ccfg.getWriteBehindBatchSize(), ccfg.getMaxConcurrentAsyncOperations(), SqlSystemViewCaches.toStringSafe(ccfg.getCacheLoaderFactory()), SqlSystemViewCaches.toStringSafe(ccfg.getCacheWriterFactory()), SqlSystemViewCaches.toStringSafe(ccfg.getExpiryPolicyFactory()), ccfg.isSqlEscapeAll(), ccfg.getSqlSchema(), ccfg.getSqlIndexMaxInlineSize(), ccfg.isSqlOnheapCacheEnabled(), ccfg.getSqlOnheapCacheMaxSize(), ccfg.getQueryDetailMetricsSize(), ccfg.getQueryParallelism(), ccfg.getMaxQueryIteratorsCount(), ccfg.getDataRegionName()});
        }, true, new IgnitePredicate[0]);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.ctx.cache().cacheDescriptors().size();
    }
}

